--- Recursive global chest with water

local castle = { o = "brick", n = "brick_u", u = "brick_d", ["["] = "brick_l", ["]"] = "brick_r",
                 x = "wall", ["="] = "trim", ["#"] = "bars",
                 [":"] = "chain_u", ["'"] = "chain_d", ["*"] = "pillar_u", ["|"] = "pillar_d"}

local water = { w = "water", ["^"] = "watersurface", ["#"] = "waterbars",
                 [":"] = "waterchain_u", ["'"] = "waterchain_d", ["*"] = "waterpillar_u", ["|"] = "waterpillar_d",
                ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
                ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
                ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr" }

local glitch = { o = "glitch", ["/"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start(wet)
  ApplyTiles(castle, 0, 0, [[
|........:..uxxxxxxx
|........:..nxxxxxxx
|........:..u[][][][
|........:.........*
|........'.........|
][]................|
xxn...........n[][][
xxu...........uxxxxx
xxn...........nxxxxx
xxu...........uxxxxx
xxn...........nxxxxx
xxu=====n.....uxxxxx
xxnxxxxxu.....nxxxxx
xxuxxxxxn.....uxxxxx
xxnxxxxxu[][][]xxxxx
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
|wwwwwwww:ww........
|wwwwwwww:ww........
|wwwwwwww:ww........
|wwwwwwww:ww79wwwww*
|wwwwwwww'ww46wwwww|
...wwwwwwwww46wwwww|
...wwwwwwwww13......
...wwwwwwwwwww......
...wwwwwwwwwww......
...wwwwwwwwwww......
...wwwwwwwwwww......
.........wwwww......
.........wwwww......
.........wwwww......
]])
  else
ApplyTiles(water, 0, 10, [[
............79......
.........^^^46......
.........www46......
.........www13......
]])
  end

  Spawn("player", 4.5, 10)
  Spawn("crystal", 15, 4.5)
  Global("chest", 7.6, 10.5, "start")
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oo/...............oo
oo................oo
oo................oo
oo................oo
oo...oo......oo...oo
oo...oo......oo...oo
oo...oo......oo...oo
oo...oooooooooo...oo
oo...oooooooooo...oo
oo...ooosoosooo...oo
oo...oooooooooo...oo
oo...oooooooooo...oo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 8.8, 7)
  Spawn("chest", 3.5, 12.5, "jaaaam")
  Spawn("chest", 16.5, 12.5, "jaaaam")

  Spawn("record", 11.6, 7.5, "sounds/voices/d8r")
end

function jaaaam()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooo/.......oooooooo
oooo........oooooooo
oooo........oooosooo
oooo........oooooooo
ooooooooooo.oosooooo
ooooooooooo.oooooooo
ooooooooooo.oooooooo
oo...............ooo
oo...............ooo
oo...............ooo
oo....oooooooooooooo
oo....oooooooooooooo
oo....oooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 4, 13)
  Spawn("lock", 13.5, 9.5)
  Spawn("diamond", 15.5, 9.5)
  Spawn("fan", 8, 9.5)
  Spawn("key", 8, 4.5)
end

tiles = "tiles/castle"
pattern = "backgrounds/tubes"
dark = {0.06, 0.01, 0.09}
light = {0.17, 0.06, 0.18}

