--- Feedback global chest with door jam

local castle = { o = "brick", n = "brick_u", u = "brick_d", ["["] = "brick_l", ["]"] = "brick_r",
                 x = "wall", ["="] = "trim", ["#"] = "bars",
                 [":"] = "chain_u", ["'"] = "chain_d", ["*"] = "pillar_u", ["|"] = "pillar_d" }

local glitch = { o = "glitch", ["/"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start()
  ApplyTiles(castle, 0, 0, [[
xxn...:....:......|.
xxu...:....:......|.
xxn...:....'......|.
xxu...:..........n[]
xxn...'..........uxx
xxu..............nxx
xxn..............uxx
xxu..............nxx
xxn======........uxx
xxuxxxxxn........nxx
[][][]xxu=====...uxx
xxxxxnxxxxxxxn...nxx
xxxxxuxxxxxxxu===uxx
xxxxx[][][][][][][][
xxxxxn....*...*....n
]])

  Spawn("player", 5.2, 7)
  Spawn("key", 15.5, 11.5)
  Global("chest", 11.5, 9.5, "corridor")
end

function corridor()
  ApplyTiles(castle, 0, 0, [[
xxxxn...........nxxx
xxxxu...........uxxx
xxxxn...........nxxx
xxxxu...........uxxx
xxxxn...........nxxx
xxxxu...........uxxx
xxxxn.......[][][][]
xxxxu.......nxxxxxxx
[][][][][][]uxxxxxxx
xxxxxn.####.nxxxxxxx
xxxxxu.####.uxxxxxxx
xxxxxn.####.nxxxxxxx
xxxxxu.####.uxxxxxxx
xxx[][][][][][]xxxxx
xxxn..........nxxxxx
]])

  Spawn("player", 7.9, 7)
  Spawn("chest", 14, 5.5, "pits")
end

function pits()
  ApplyTiles(castle, 0, 0, [[
|::.n.'u..:.::n.'::|
|':.u..n..'.':u..:'|
|.:.n..u.....'n..'.|
|.'.u.........u....|
|..................|
|..................|
|......[][][]...[][]
|...............nxxx
[]n.............uxxx
xxu.............nxxx
xx[]o...........uxxx
xxo[]...........nxxx
xxn=============uxxx
xxuxxxxxxxxxxxxxnxxx
xxnxxxxxxxxxxxxxuxxx
]])

  Spawn("player", 10, 11)
  Spawn("lock", 7.5, 4.5)
  Spawn("crystal", 11.5, 4.5)

  Spawn("record", 13.8, 11.5, "sounds/voices/d9")
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oo/..............ooo
oo...............ooo
oo...............ooo
oo...............ooo
oo...............ooo
oo.......ooooo...ooo
oo.......ooooo...ooo
oo.......oosoo...ooo
oooooooooooooo...ooo
ooooooooooosoo...ooo
oooooooooooooo...ooo
ooooooooooosoo...ooo
oooooooooooooooooooo
]])

  Spawn("player", 4.1, 8)
  Spawn("chest", 15.5, 12.5, "ladder")

  Spawn("record", 7.2, 8.5, "sounds/voices/d9r")
end

function ladder()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
ooo/.............ooo
ooo..............ooo
ooo..............ooo
ooo....ooo.......ooo
ooo....oso.......ooo
ooo....ooo.......ooo
oooooooooo.......ooo
oooooooooo.......ooo
oooooooooo.......ooo
oooooooooo.......ooo
oooooooooo.......ooo
oooooooooo.......ooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("chest", 5, 6.5, "tall")
  Spawn("fan", 11.1, 12.5)
  Spawn("player", 15.2, 12)
end

function tall()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
ooo..............ooo
ooo..............ooo
ooo..............ooo
oooooo...........ooo
oooooo...........ooo
ooosoo...........ooo
oooooo...........ooo
oooooo...........ooo
ooooooooo........ooo
ooooooooo........ooo
oooooosoo........ooo
ooooooooo........ooo
ooooooooo........ooo
oooooooooooooooooooo
]])

  Spawn("diamond", 4.5, 2.5)
  Spawn("player", 15.5, 13)
end

tiles = "tiles/castle"
pattern = "backgrounds/tubes"
dark = {0.06, 0.01, 0.09}
light = {0.17, 0.06, 0.18}

