-- Chest and instance introduction

local cave = { ["7"] = "box_ul", ["8"] = "box_u", ["9"] = "box_ur",
               ["4"] = "box_l", ["o"] = "box_c1", ["O"] = "box_c2", ["6"] = "box_r",
               ["1"] = "box_dl", ["2"] = "box_d", ["3"] = "box_dr",
               ["u"] = "stal_cap", ["|"] = "stal_c", ["v"] = "stal_d",
               ["x"] = "block" }

function start()
  ApplyTiles(cave, 0, 0, [[
ooO6v...v|.......v79
oOo6.....v........13
2223............7889
78889...........4oO6
4oOo6...........4oo6
4Ooo6xxxxxxx.xxx1223
4OOo6|..v.v|.|v|.v.|
12223|.....|.|.|...|
889v.|.....|.|.v...|
oo6..u.....v.|.....u
223..........v.....7
|..................4
u..................1
8889788897889xxxxx78
oOo64Ooo64oO6788894o
]])

  Spawn("player", 8.5, 4)
  Spawn("chest", 1.8, 12.5, "chamber")
  Spawn("lock", 5.5, 11.5)
  Spawn("chest", 12.5, 12.5, "under")

  Spawn("bird", 10.2, 3.5, {"chest-chamber"})
end

function under()
  ApplyTiles(cave, 0, 0, [[
O646..|v.......|..4O
2313..|........v..4o
8889..v...........4o
ooO6..............12
oOo6.............788
2223.............4oo
88979............122
oO646.............78
22346.............4O
88946x............4o
oO646x............12
oo61378979......7888
223794o6467889794oOo
88913123461223134Ooo
oO678889137978894ooO
]])

  Spawn("player", 8.2, 10)
  Spawn("key", 13.5, 11.5)

  Spawn("record", 4.5, 5.5, "sounds/voices/c5")
end

function chamber()
  ApplyTiles(cave, 0, 0, [[
|..v..v|v|...v.|v.v|
u......|.v.....|...u
89.....v.......v...7
o6x................4
23x................4
7889...............1
4oO6............7888
4Oo6............4oOo
1223............1222
8979.........7978897
o646.........1312234
O646.......788897894
2313.......4ooO64o61
8897889xxxx4oOo64O67
oO64OO678894oOO61234
]])

  Spawn("player", 6.6, 12)
  Spawn("crystal", 17.5, 4.5)
end

tiles = "tiles/cave"
pattern = "backgrounds/checker"
dark = { 0.17, 0.19, 0.48 }
light = { 0.22, 0.24, 0.62 }

