-- The story of the key that could

local outrun = { o = "box", O = "monobox",
                 T = "pave", x = "ceil", ["|"] = "pillar",
                 ["-"] = "ledge", [":"] = "shroom1", [","] = "shroom2", [";"] = "shroom3",
                 ["7"] = "block_ul", ["8"] = "block_u", ["9"] = "block_ur",
                 ["4"] = "block_l", ["5"] = "block", ["6"] = "block_r" }

local water = { w = "water", ["^"] = "watersurface",
                ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
                ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
                ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr" }

function start()
  ApplyTiles(outrun, 0, 0, [[
|xxxxxxxxxxxxxxxxxx|
|..................|
|..................|
|.......;:.........|
|.....7889.........|
|.....4556.........|
|.....4556..,:.....|
8889--ooooooooo....7
5556...............4
oooo...............4
9..................4
6..................4
6........789.......4
6........456.......4
688889TTT456TTTTT788
]])

  ApplyTiles(water, 0, 9, [[
....^^^^^^^^^^^^^^^.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwww...wwwwwww.
.wwwwwwww...wwwwwww.
....................
]])

  Spawn("player", 8, 3)
  Spawn("chest", 2.5, 6.5, "marathon")
  Spawn("chest", 13, 6.5, "athens")
end

function marathon(wet)
  ApplyTiles(outrun, 0, 0, [[
555555|555555|555555
xxxxxx|555555|555555
89....|555555|555555
56....|555555|555555
56....oxxxxxxoxxxxxx
56...............788
56...............455
788889...........455
455556...........455
455556...........455
455556...........788
888889...........455
555556...........455
555556788889TTTTT455
55555645555678889455
]])

  if wet then
    ApplyTiles(water, 0, 2, [[
..wwww..............
..wwww..............
..wwww..............
..wwww789wwwwwwww...
..wwww456wwwwwwww...
......123wwwwwwww...
......wwwwwwwwwww...
......wwwwwwwwwww...
......wwwwwwwwwww...
......wwwwwwwwwww...
......wwwwwwwwwww...
]])
  else
    ApplyTiles(water, 0, 10, [[
......789...........
......456...........
......123...........
]])
  end

  Spawn("player", 4, 6)
  Global("key", 11.5, 12.5)
  Spawn("yield", 15.5, 12)

  Spawn("record", 7.4, 9.5, "sounds/voices/v2")
end

function athens(wet)
  ApplyTiles(outrun, 0, 0, [[
5555|xxxxxxxxx|55555
5555|.........|5oxxx
xxxxo...;:....|5|...
|.............|5|...
|.............|5|...
|.............|5oTTT
|...o...|.....|55555
|..,|...o.....oxxxxo
8889|......o.......|
5556|......|.......|
5556|....,:|.....;:|
5556|...789|...78888
88889...456|...45555
55556...456|...45555
55556TTT456|TTT45555
]])

  if wet then
    ApplyTiles(water, 0, 6, [[
.^^^.789.^^^^^......
.www.456.wwwww......
.....123www.789wwww.
.....wwwwww.456wwww.
.....wwwwww.123wwww.
.....www....www.....
.....www....www.....
.....www....www.....
]])
  else
    ApplyTiles(water, 0, 11, [[
.....789....789.....
.....456....456.....
.....123....123.....
]])
  end

  -- apply overhang after water effect is placed
  ApplyTiles(outrun, 0, 3, [[
.......7889.........
.......4556.........
.......oooo.........
]])

  Spawn("player", 2.5, 7)
  Spawn("yield", 10, 10)
  Spawn("lock", 15.6, 9.5)
  Spawn("crystal", 17.5, 9.5)
end

tiles = "tiles/outrun"
pattern = "backgrounds/void"
dark = { 0.04, 0.08, 0.12 }
light = { 0.06, 0.17, 0.21 }


