-- Inflexible chest

local outrun = { o = "box", O = "monobox",
                 T = "pave", x = "ceil", ["|"] = "pillar",
                 ["-"] = "ledge", [":"] = "shroom1", [","] = "shroom2", [";"] = "shroom3",
                 ["7"] = "block_ul", ["8"] = "block_u", ["9"] = "block_ur",
                 ["4"] = "block_l", ["5"] = "block", ["6"] = "block_r" }

local glitch = { o = "glitch", [">"] = "glitchd", ["-"] = "glitchledge" }

function start()
  ApplyTiles(outrun, 0, 0, [[
xxxxxxxxxxxxxxxxxxxx
|..................|
|..................|
|..................|
|.............oo...7
|..................4
|.......O..........4
|..................4
|..O.............788
9................455
6................455
6......O.........455
6..............78888
6,;:;,:,.......45555
88889TTTTTTTTTT45555
]])

  Spawn("player", 13.5, 13)
  Global("chest", 15, 3.5, "limbo")

  Spawn("record", 17.9, 7.5, "sounds/voices/v5")
end

function limbo()
  ApplyTiles(outrun, 0, 0, [[
xxxxxxxxxxxxxxxxxxxx
|..................|
|..................|
|..................|
|..................|
|..................|
9..................|
6............,:....|
6............7888888
6.:;.........4555555
8889.........4555555
5556.........4555555
5556.......788888888
5556.......455555555
5556TTTTTTT455555555
]])

  Spawn("player", 6, 13)
  Spawn("yield", 9, 13)
  Spawn("chest", 16.5, 7.5, "lust")
end

function lust()
  ApplyTiles(outrun, 0, 0, [[
xxxxxxxxxxxxxxxxxxxx
|..................|
|..................|
9..................|
6..................|
6..................|
6..................|
6...,:;............|
8888889............|
5555556...........,|
5555556.........7888
5555556;:.......4555
555578889.......4555
555545556.......4555
5555455568889TTT4555
]])

  Spawn("player", 14, 13)
  Spawn("crystal", 3.5, 3.5)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
oo................oo
oo................oo
oo................oo
oo..........oooooooo
oo..........oooooooo
oo..........oo.ooooo
oo..........oooooooo
oo..........oooooooo
ooooooooooooooooo.oo
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 3.4, 10)
  Spawn("key", 7.1, 10.5)
  Global("chest", 10.0, 10.5, "dungeon")
  Spawn("lock", 12.5, 4.5)
  Spawn("lock", 14.5, 4.5)
  Spawn("diamond", 16.5, 4.5)

  Spawn("record", 5.6, 10.5, "sounds/voices/v5r")
end

function dungeon()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooo............>ooo
oooo.............ooo
oooo.............ooo
oooo.............ooo
oooo.............ooo
oooooooooo.......ooo
oooooo.o>o.......ooo
oooooooooo.......ooo
ooooo........ooooooo
ooooo........ooooooo
ooooo........oo.oooo
ooooo.....oooooooooo
ooooo.....oooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 7.1, 5)
  Spawn("chest", 8.5, 13.5, "oubliette")
  Global("fan", 11.2, 11.5)
end

function oubliette()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooooo.o.oo.o>oooooo
oooooooooooooooooooo
oooo...........>oooo
oooo............oooo
oooo............oooo
oooo............oooo
oooo............oooo
oooooooooooooooooooo
oooooooooooooooooooo
oooooo.o.oo.o.oooooo
oooooooooooooooooooo
oooooooo.oo.oooooooo
oooooooooooooooooooo
]])

  Spawn("player", 10, 8)
end

tiles = "tiles/outrun"
pattern = "backgrounds/void"
dark = { 0.04, 0.08, 0.12 }
light = { 0.06, 0.17, 0.21 }

