-- The final challenge

local outrun = { o = "box", O = "monobox",
                 T = "pave", x = "ceil", ["|"] = "pillar",
                 ["-"] = "ledge", [":"] = "shroom1", [","] = "shroom2", [";"] = "shroom3",
                 ["7"] = "block_ul", ["8"] = "block_u", ["9"] = "block_ur",
                 ["4"] = "block_l", ["5"] = "block", ["6"] = "block_r" }

local acid = { a = "acid", ["^"] = "acidsurface", ["-"] = "acidledge",
               ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
               ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
               ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr" }

local glitch = { o = "glitch", [">"] = "glitchd", ["-"] = "glitchledge" }

function start()
  ApplyTiles(outrun, 0, 0, [[
xoxxxxxxxxxxxxxxxxox
9|................|7
6|................|4
6|................|4
6|................|4
6|:,..............|4
888889o...o...o...o4
555556|...|...|...|4
555556|...|...|...|7
788889|...|...|...|4
455556|...|...|...|4
455556|...|...|...|4
455556|...|...|,;:|4
455556oTTToTTToTTTo4
45555678888897888888
]])
  
  Spawn("player", 4.5, 5)

  Spawn("chest", 8.5, 12.5, "boxes")
  Spawn("chest", 12.5, 12.5, "keys")
  Spawn("chest", 16.5, 12.5, "chests")

  Spawn("record", 2.5, 5.5, "sounds/voices/v6")
end

function boxes()
  ApplyTiles(outrun, 0, 0, [[
oxxxxxxxxxxxxxxxxxxo
|..................|
|..................|
|..................|
|...............7888
|...............oooo
|.................|.
9.................|.
6.................|.
6.................|.
6.................|.
6---78889.........|.
6...45556..,.:,:;,|:
6...45556TTTTTT78888
88894555678888945555
]])

  Spawn("player", 2.5, 13)
  Spawn("box", 5.8, 10.5)
  Spawn("box", 10.2, 12.5)
  Spawn("box", 14.1, 12.5)
  Spawn("box", 17.3, 12.5)
  Spawn("chest", 17.5, 3.5, "finalroom")
end

function keys()
  ApplyTiles(outrun, 0, 0, [[
oxxxxxxxxxxxxx|5555|
|.............|5555|
|.............|5555|
|.............|5555|
|.............oxxxxo
|.........O........|
|..................|
|..789.............|
|..456;.......oo7888
|..TTTTTTTTTTTTT4555
|.....O.O.O.....4555
|...............4555
|...............4555
|:,............;4555
o7888889TTT788888978
]])

  Spawn("player", 7.4, 8)
  Spawn("lock", 10.5, 7.5)
  Spawn("lock", 14.5, 6.5)
  Spawn("lock", 16.0, 6.5)
  Spawn("key", 4.7, 6.5)
  Global("key", 17.9, 7.5)
  Spawn("lock", 6.5, 12.5)
  Spawn("lock", 8.5, 12.5)
  Spawn("lock", 10.5, 12.5)
  Spawn("chest", 13.5, 13.5, "finalroom")
end

function chests(wet)
  ApplyTiles(outrun, 0, 0, [[
|555|xxxxxxxxxxxxxx|
oxxxo..............|
|555|..............|
|555|..............|
|555|..............|
oxxxo..............|
|..................|
|..................|
|..................|
|...79......o------o
|...46;:,...|......|
788888888889|......|
455555555556|.....,|
455555555556TTTTTTT7
45555555555688888884
]])
  
  if wet then
     ApplyTiles(acid, 0, 1, [[
.....aaaaaaaaaaaaaa.
.....aaaaaaaaaaaaaa.
.....aaaaaaaaaaaaaa.
.....aaaaaaaaaaaaaa.
.....aaaaaaaaaaaaaa.
.aaaaaaaaaaaaaaaaaa.
.aaaaaaaaaaaaaaaaaa.
.aaaaaaaaaaaaaaaaaa.
.aaa..aaaaaa.------.
.aaa..aaaaaa.aaaaaa.
.............aaaaaa.
.............aaaaaa.
]])
  end

  Spawn("player", 7.5, 10)
  Global("chest", 10.5, 10.5, "chests")
  Spawn("key", 15.2, 12.5)
  Spawn("lock", 4.5, 7.5)
  Spawn("chest", 2.5, 10.5, "finalroom")
end

function finalroom(wet)
  ApplyTiles(outrun, 0, 0, [[
....................
88888889..........78
55555556..........45
55555556..........45
888888889.........45
555555556.........45
555555556.......7888
8888888889......4555
oooooooooo......4555
.|.............78888
.|.............45555
.|.............45555
.|...o788889TTT45555
:|...|45555678888889
ToTTTo45555645555556
]])

  if wet then
    ApplyTiles(acid, 0, 2, [[
........^^^^^^^^^^..
........aaaaaaaaaa..
.........aaaaaaaaa..
.........aaaaaaaaa..
.........aaaaaaa....
..........aaaaaa....
..........aaaaaa....
a.aaaaaaaaaaaaa.....
a.aaaaaaaaaaaaa.....
a.aaaaaaaaaaaaa.....
a.aaa...............
a.aaa...............
]])
  end

  Spawn("player", 3.5, 13)
  Spawn("crystal", 16.5, 2.2)
  Spawn("chest", -0.4, 0.5, "secrettunnel")
end

function secrettunnel(wet)
  ApplyTiles(outrun, 0, 0, [[
|xxxxxxxxxxx|5|5555|
|...........|5|5555|
|...........|5|5555|
|...........|5|5555|
|.....79....|5oxxxxo
|.....46....|5|....|
oTTTTT46....|5|....|
78888889....|5|....|
45555556....|5|....|
45555556....|5|....|
45555556....oxo..788
88888889.........455
55555556.........455
55555556------...455
55555556.........455
]])

  if wet then
    ApplyTiles(acid, 0, 2, [[
.^^^^^^^^^^^........
.aaaaaaaaaaa........
.aaaaa..aaaa........
.aaaaa..aaaa........
........aaaa........
........aaaa........
........aaaa........
........aaaa........
........aaaa........
........aaaaaa789...
........aaaaaa456...
........------123...
........aaaaaaaaa...
]])
  else
    ApplyTiles(acid, 0, 13, [[
..............789...
..............456...
]])
  end

  Spawn("player", 2.1, 5)
  Spawn("chest", 18, 9.5, "apex")

  Spawn("record", 4.9, 5.5, "sounds/voices/v6b")
end

function apex(wet)
  ApplyTiles(outrun, 0, 0, [[
xoxxxxxxxxxxxxxxxxox
.|................|.
.|................|.
.|................|.
.|................|.
.|.......79.......|.
.|..oTTTTTTTTTTo..|.
.|................|.
.|................|.
.|................|.
.|................|.
.|...........79...|.
.|.......;:;,4678888
888889TTTT7894645555
55555678894564645555
]])

  if wet then
    ApplyTiles(acid, 0, 3, [[
^..................^
a..................a
a..................a
a..................a
a.789aaaaaaaaaa789.a
a.456aaaaaaaaaa456.a
a.123aaaaaaaaaa123.a
a.aaaaaaaaaaaaaaaa.a
a.aaaaaaaaaaa..aaa.a
a.aaaaaaaaaaa.......
]])
else
    ApplyTiles(acid, 0, 9, [[
...............789..
..789..........456..
..456..........123..
..123...............
]])
end

  Spawn("player", 6.5, 12)
  Global("crux", 10, 3)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
oo...............>oo
oo................oo
oo................oo
oo................oo
oo.....oo.........oo
oo.....oo.........oo
oo.....oo.........oo
oo...ooooooooooooooo
oo...ooooooooooooooo
oo...oo.oo.oo.oooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 3.5, 12)
  Spawn("chest", 11.1, 9.5, "contraflow")
  Spawn("chest", 13.5, 9.5, "counterblock")
  Spawn("box", 15.9, 9.5)

  Spawn("record", 16.1, 8.4, "sounds/voices/v6r")
end

function counterblock()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
oo........>oo.oooooo
oo.........ooooooooo
oo.........ooooooooo
oo.................o
oo.................o
oo.................o
oooooo....oooooooooo
oooooo....oooooooooo
oooooo....oooooooooo
oooooo....oooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  ApplyTiles(acid, 0, 9, [[
......^^^^..........
......aaaa..........
......aaaa..........
......aaaa..........
]])

  Spawn("player", 4.1, 8)
  Global("lock", 12.5, 7.5)
  Spawn("lock", 14.5, 7.5)
  Spawn("diamond", 17.5, 7.5)
end

function contraflow(wet)
  ApplyTiles(glitch, 0, 0, [[
o...............oooo
o...............oooo
o...........oooooooo
ooo.........oooooooo
ooo............ooooo
ooo............ooooo
ooo............ooooo
ooo...........oooooo
oooooooooo.........o
oooooooooo.........o
oooooooooo.........o
oooooooooo...ooo...o
oooooooooooooooo...o
oooooooooooooooo...o
oooooooooooooooooooo
]])

  if wet then
    ApplyTiles(acid, 0, 3, [[
...^^^^^^^^^........
...aaaaaaa789aa.....
...aaaaaaa456aa.....
...aaaaaaa123aa.....
...aaaaaaa789a......
..........456aaaaaa.
..........123aaaaaa.
..........aaaaaaaaa.
..........aaa...aaa.
................aaa.
................aaa.
]])
  else
  ApplyTiles(acid, 0, 6, [[
..........789.......
..........456.......
..........123.......
..........789.......
..........456.......
..........123.......
]])
  end

  Spawn("player", 7.5, 7)
  Global("fan", 2, 2,5)
  Spawn("key", 17.5, 13.5)
end

tiles = "tiles/outrun"
pattern = "backgrounds/void"
dark = { 0.04, 0.08, 0.12 }
light = { 0.06, 0.17, 0.21 }

