-- Water / global door latch

local villa = { o = "stone", t = "stonetop", ["8"] = "stucco",
                ["7"] = "arch_l", ["9"] = "arch_r", ["1"] = "stonebottom_l", ["3"] = "stonebottom_r",
                ["|"] = "pillar",  ["T"] = "pillartop", ["/"] = "grasspillar",
                [">"] = "shadowtop_l", ["}"] = "shadow_l", ["<"] = "shadowtop_r", ["{"] = "shadow_r",
                ["x"] = "ivy_a", ["X"] = "ivy_b", ["+"] = "ivy_c",
                ["$"] = "hang_a", ["%"] = "hang_b", ["&"] = "hang_c",
                ["#"] = "bush_a", ["@"] = "bush_a",
                [","] = "grass_a", [":"] = "grass_b", [";"] = "grass_c" }

local water = { w = "water", ["^"] = "watersurface",
                ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
                ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
                ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr",
                [">"] = "waterarch_l", ["}"] = "waterstonebottom_l",
                ["<"] = "waterarch_r", ["{"] = "waterstonebottom_r" }

function start()
  ApplyTiles(villa, 0, 0, [[
oooo.............ooo
oooo.............ooo
ooo3.............1oo
T..................T
|,.................|
|x..............,:;|
/X..............t%&t
/x..............oXxo
/...............Xxoo
/.............;:xooo
ttttt........t&%$t>o
ooooo........oxXxo}o
oo<tttttt....ooxX+}o
oo{oooooottttoooxo}o
oo{o8888o7..9oooXx}o
]])

  Spawn("player", 3.1, 9)
  Spawn("chest", 14.4, 9.5, "dunk")
end

function dunk(wet)
  ApplyTiles(villa, 0, 0, [[
ooo.............oo{o
ooo...........tttttt
oo3...........1ooooo
T...............T.oo
|...............|.oo
|.............;;|.oo
tt.;,:,.......%&tttt
ooo%&%+.....oxXxoooo
oooxxoo.....oooxoooo
ooX+o7.........9ooox
ooxxX...........#ooX
ox+X@...........@xx+
oox#@...........#@xX
oxXx##@.........@#X+
oo+x+#@#@#%#$@@#@#xo
]])

  ApplyTiles(water, 0, 10, [[
.....^^^^^^^^^^^....
.....wwwwwwwwwww....
.....wwwwwwwwwww....
.......wwwwwwwww....
]])

  Spawn("player", 5.6, 6)
  Spawn("chest", 13.1, 6.5, "floodgate")

  Spawn("record", 15.2, 5.5, "sounds/voices/r1")
end

function floodgate(wet)
  ApplyTiles(villa, 0, 0, [[
o|...............ooo
o|...............ooo
o|............;:.ooo
o|...........t%&tttt
o|..........;Xx7...T
ttttt......t$&%....|
ooooo......oXxx....|
oooo3......1xo+..../
T................../
|................../
|..................|
/...........tttttttt
ttttt.......oooooooo
oo<tttt..ttttt>o8o8o
oo{oooo..ooooo}ooooo
]])

  if wet then
    ApplyTiles(water, 0, 2, [[
.......79...........
.......46...........
.......46...........
.....^^46^^....^^^^.
.....ww46ww....wwww.
....{ww46ww}...wwww.
.wwwwww46wwwwwwwwww.
.wwwwww46wwwwwwwwww.
.wwwwww46wwwwwwwwww.
.wwwwww46www........
.....ww46www........
.......46...........
.......46...........
]])
  else
    ApplyTiles(water, 0, 11, [[
.......79...........
.......46...........
.......46...........
.......46...........
]])
  end

  Spawn("player", 2.8, 11)
  Spawn("key", 3.1, 4.5)
  Global("lock", 13.5, 9.5)
  Spawn("crystal", 17, 5.5)
end

tiles = "tiles/villa"
pattern = "backgrounds/growth"
dark = { 0.16, 0.11, 0.10 }
light = { 0.34, 0.21, 0.16 }

