-- Acid chest move

local villa = { o = "stone", t = "stonetop", ["8"] = "stucco",
                ["7"] = "arch_l", ["9"] = "arch_r", ["1"] = "stonebottom_l", ["3"] = "stonebottom_r",
                ["|"] = "pillar",  ["T"] = "pillartop", ["/"] = "grasspillar",
                [">"] = "shadowtop_l", ["}"] = "shadow_l", ["<"] = "shadowtop_r", ["{"] = "shadow_r",
                ["x"] = "ivy_a", ["X"] = "ivy_b", ["+"] = "ivy_c",
                ["$"] = "hang_a", ["%"] = "hang_b", ["&"] = "hang_c",
                ["#"] = "bush_a", ["@"] = "bush_a",
                [","] = "grass_a", [":"] = "grass_b", [";"] = "grass_c" }

local acid = { a = "acid", ["^"] = "acidsurface",
               ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
               ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
               ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr",
               [">"] = "acidarch_l", ["}"] = "acidstonebottom_l",
               ["<"] = "acidarch_r", ["{"] = "acidstonebottom_r" }

function start()
  ApplyTiles(villa, 0, 0, [[
oo.........|.|....,/
o3.........|.|....x/
T..........|.|....X/
|.......tttttt....x/
|:;.....oooooo...../
@$&3......9oo7.....|
%xX........oo......|
ox+,:,.....oo...tttt
<t&%%tt....13..1oooo
{oxXxoo.........o88o
{o+Xoo..........oooo
{Xxooo..........o88o
t&t>oo..........oooo
oxo}ooooooooooooo88o
oXo}oooooooooooooooo
]])

  ApplyTiles(acid, 0, 8, [[
.......^^^^}{^^}....
......{aaaaaaaaa....
......aaaaaaaaaa....
......aaaaaaaaaa....
......aaaaaaaaaa....
]])

  Spawn("player", 4, 7)
  Spawn("key", 2.2, 4.5)
  Global("key", 9.3, 2.5)
  Spawn("chest", 17.5, 6.5, "crypt")

  Spawn("record", 12.8, 12.5, "sounds/voices/r3")
end

function crypt(wet)
  ApplyTiles(villa, 0, 0, [[
xooooo|.|.........|o
&ttttttttt........tt
Xo7...9ooo........oo
xX.....ooo........1o
x+.....oo3.........T
oX.....oo..........|
t&ttttttt........../
T................../
|..............tttt&
|......,:,.....ooox+
ttttttt%$@;...ttttt%
oooooooxX#@:,;ooooox
&tt>oooXx&%$&$ooo<tt
xoo}oooxoxXxxXooo{oo
Xxotttt%t&$%$$ttttoo
]])

  if wet then
    ApplyTiles(acid, 0, 1, [[
..........^^^^^^^^..
..>aaa<...aaaaaaaa..
..aaaaa...aaaaaaaa}.
..aaaaa..{aaaaaaaaa.
..aaaaa..aaaaaaaaaa.
.........aaaaaaaaaa.
.aaaaaaaaaaaaaaaaaa.
.aaaaaaaaaaaaaa.....
.aaaaaaaaaaaaaa.....
..........aaaa......
...........aaa......
]])
  end

  Spawn("player", 3.2, 9)
  Spawn("lock", 6.5, 8.5)
  Spawn("lock", 8.5, 8.5)
  Spawn("chest", 17.1, 7.5, "attic")
end

function attic(wet)
  ApplyTiles(villa, 0, 0, [[
oooo...............|
o88o...............|
oooo...............|
ooo3...............|
T.............,:,;:|
|............t&@#@@$
|............xX%@#&+
tt...........o+x%$xX
oo...........ooXx+Xo
oo...........oX+Xxoo
oo.........ttt&%>Xxo
<tttt......oo+Xx}oXx
{oooo.,:;..ooXxo}oxo
{oooot%&tttox+Xo}+Xo
{oooo+Xxooo+Xxoo}oXx
]])

  if wet then
    ApplyTiles(acid, 0, 0, [[
....aaaaaaaaaaaaaaa.
....aaaaaaaaaaaaaaa.
....aaaaaaaaaaaaaaa.
...{aaaaaaaaaaaaaaa.
.aaaaaaaaaaaaaaaaaa.
.aaaaaaaaaaaa.......
.aaaaaaaaaaaa.......
..aaaaaaaaaaa.......
..aaaaaaaaaaa.......
..aaaaaaaaaaa.......
..aaaaaaaaa.........
.....aaaaaa.........
.....aaaaaa.........
]])
  end

  Spawn("player", 3.9, 10)
  Spawn("crystal", 16.5, 2.5)
end

tiles = "tiles/villa"
pattern = "backgrounds/growth"
dark = { 0.14, 0.10, 0.12 }
light = { 0.26, 0.19, 0.23 }

