-- Global chest water feedback

local villa = { o = "stone", t = "stonetop", ["8"] = "stucco",
                ["7"] = "arch_l", ["9"] = "arch_r", ["1"] = "stonebottom_l", ["3"] = "stonebottom_r",
                ["|"] = "pillar",  ["T"] = "pillartop", ["/"] = "grasspillar",
                [">"] = "shadowtop_l", ["}"] = "shadow_l", ["<"] = "shadowtop_r", ["{"] = "shadow_r",
                ["x"] = "ivy_a", ["X"] = "ivy_b", ["+"] = "ivy_c",
                ["$"] = "hang_a", ["%"] = "hang_b", ["&"] = "hang_c",
                ["#"] = "bush_a", ["@"] = "bush_a",
                [","] = "grass_a", [":"] = "grass_b", [";"] = "grass_c" }

local water = { w = "water", ["^"] = "watersurface",
                ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
                ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
                ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr",
                [">"] = "waterarch_l", ["}"] = "waterstonebottom_l",
                ["<"] = "waterarch_r", ["{"] = "waterstonebottom_r" }

local glitch = { o = "glitch", ["/"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start(wet)
  ApplyTiles(villa, 0, 0, [[
ooooooo............|
o8o8o8o............|
ooooooo........ttttt
ooooooo........1oooo
T...ooo...........+x
|...ooo...,,;.....oX
|...1oo...%#@.....1o
|....13...x@%......T
|.........X$x......|
|.........xx+......|
|.........oXo......|
|.........o<tttttttt
|......:;.o{oooooooo
|.....,%$to{oooooooo
tttttt&xooo{oooooooo
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
.......wwwwwwwwwwww.
.......wwwwwwwwwwww.
.......wwwwwwww.....
.......wwwwwwww}....
.www...wwwwwwwwwww..
.www...wwwwwwwwwww..
.www}..www...wwwww}.
.7889}{www...wwwwww.
.4556wwwww...wwwwww.
.1223wwwww...wwwwww.
.wwwwwwwww...wwwwww.
.wwwwwwwww..........
.wwwwwwwww..........
.wwwwww.............
]])
  else
    ApplyTiles(water, 0, 11, [[
.7889...............
.4556...............
.1223...............
]])
  end

  Spawn("player", 14.3, 10)
  Global("chest", 17.1, 10.5, "gloop")
  Spawn("key", 16, 1.5)
  Spawn("crystal", 2.5, 5.5)
end

function gloop(wet)
  ApplyTiles(villa, 0, 0, [[
ooo......1ooooooooxX
oo3............9ooox
T...............ooo+
|...............oooo
|....1oooooooooooooo
tt................9T
oo.................|
8o................./
oo...............,:/
8o........,:.....%@$
oo...,:;,:@#.....@$+
ttttt$%$###@.....#xo
ooooXx+Xx@.......@Xx
oooxxoxx#@....##@#x+
oo+XooXx+#@##@#@%@Xx
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
...wwwwww}..........
..{wwwwwwwwwwwww....
.w789wwwwwwwwwww....
.w456wwwwwwwwwww....
.w456}..............
..123wwwwwwwwwwwww<.
..wwwwwwwwwwwwwwwww.
..wwwwwwwwwwwwwwwww.
..wwwwwwwwwwwwwwwww.
..wwwwwwwwwwwwwww...
..wwwwwwww..wwwww...
............wwwww...
..........wwwwwww...
..........wwww......
....................
]])
  else
    ApplyTiles(water, 0, 7, [[
..789...............
..456...............
..456...............
..123.......^^^^^...
............wwwww...
..........wwwwwww...
..........wwww......
]])
  end

  Spawn("player", 6.3, 10)
  Spawn("chest", 11, 9.5, "start")
  Spawn("lock", 10.5, 2.5)
  Spawn("box", 14.1, 3.5)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooo/.....oooooooooo
oooo......oooooooooo
oooo......o/.....ooo
oooo......o......ooo
oooo...o--o......ooo
oooo...o.........ooo
oooo...o.........ooo
oooo...ooooooooooooo
oooo.......ooooooooo
oooo.......ooooosooo
oooo.......ooooooooo
oooo.......ooooosooo
oooooooooooooooooooo
]])

  Spawn("player", 12.1, 8)
  Spawn("chest", 8.7, 13.5, "crisscross")

  Spawn("record", 15.7, 8.5, "sounds/voices/r5r")
end

function crisscross()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oosoo..............o
ooooo..............o
ooooo..............o
o......oooo........o
o......oooo........o
o......oooo........o
o...ooooooo........o
o..................o
o..................o
o..................o
oooooooo...........o
oooooooo...........o
osososoo...........o
oooooooo---------ooo
]])

  Spawn("lock", 8.25, 2.5)
  Spawn("diamond", 10.25, 2.5)
  Spawn("key", 2.7, 10.5)
  Spawn("fan", 5.4, 10.5)
  Spawn("player", 18, 13)
end

tiles = "tiles/villa"
pattern = "backgrounds/growth"
dark = { 0.16, 0.11, 0.10 }
light = { 0.34, 0.21, 0.16 }

