-- Acid global chest feedback loop

local villa = { o = "stone", t = "stonetop", ["8"] = "stucco",
                ["7"] = "arch_l", ["9"] = "arch_r", ["1"] = "stonebottom_l", ["3"] = "stonebottom_r",
                ["|"] = "pillar",  ["T"] = "pillartop", ["/"] = "grasspillar",
                [">"] = "shadowtop_l", ["}"] = "shadow_l", ["<"] = "shadowtop_r", ["{"] = "shadow_r",
                ["x"] = "ivy_a", ["X"] = "ivy_b", ["+"] = "ivy_c",
                ["$"] = "hang_a", ["%"] = "hang_b", ["&"] = "hang_c",
                ["#"] = "bush_a", ["@"] = "bush_a",
                [","] = "grass_a", [":"] = "grass_b", [";"] = "grass_c",
                ["'"] = "ledge" }

local acid = { a = "acid", ["^"] = "acidsurface",
               ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
               ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
               ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr",
               [">"] = "acidarch_l", ["}"] = "acidstonebottom_l",
               ["<"] = "acidarch_r", ["{"] = "acidstonebottom_r" }

local glitch = { o = "glitch", ["/"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start()
  ApplyTiles(villa, 0, 0, [[
ooooooo.........oooo
o8o8o8o.........1ooo
oooooo3...........9T
t%&t...............|
oxXo..............,|
ooxo.............t@%
ooo3.............o#x
T.T.............oo@X
|.|.............oo%x
|./.....ttttt...ooxo
/,/:....ooooooooooXo
%&$&tttttt>oo7.9o+xo
+Xxxoooooo}oo...oXxo
o+Xxoooooo}oo...ooXx
xXo+Xxoooo}oo...o+xo
]])

  Spawn("player", 5.1, 10)
  Spawn("chest", 14.4, 9.5, "scoop")
end

function scoop(wet)
  ApplyTiles(villa, 0, 0, [[
/X......|.|.oo.....|
/x......|.|.oo.....|
/.......|,|:o3.....|
/.......tttto......|
|.......ooooo......|
|;,:....ooooo......|
t#@%t...ooooo..ttttt
o%&xo...ooooo..ooooo
Xx+oo...oooo3..o8o8o
oxXxo...oo3....ooooo
%&>xo..........o8o8o
Xx}oo..........ooooo
xo}oo........ooooooo
oo}ooooooooo{ooo<ttt
oo}ooooooooo{ooo{ooo
]])

  ApplyTiles(acid, 0, 6, [[
.....^^^.....^^.....
.....aaa.....aa.....
.....aaa....{aa.....
.....aaa..{aaaa.....
.....aaaaaaaaaa.....
.....aaaaaaaaaa.....
.....aaaaaaaa.......
]])

  Spawn("player", 4.1, 5)
  Spawn("chest", 1.9, 5.5, "stagger")
  Global("chest", 17.2, 5.5, "climp")
  Spawn("lock", 9.5, 11.5)
end

function stagger(wet)
  ApplyTiles(villa, 0, 0, [[
Xxo|...........|oooo
xoo|..........ttt&$t
ooo|:,........oooxXx
t%$&%tt.......1ooo+x
oXxXxoo........9oooX
+x+xoo3.........oo+x
xXxoo7..........oooX
xo+xo...........1oox
ooxo3..,;:,.......9o
ooo7...&@#%t.......o
ooo....o%&oo....tttt
ttttttttt%t>,:;,oooo
oooooooo<t&%$%&ttt>o
o8oo8oo8{oXx+Xxooo}o
oooooooo{o+Xo+Xxoo}o
]])

  if wet then
  ApplyTiles(acid, 0, 0, [[
....aaaaaaaaaaa.....
....aaaaaaaaaa......
....aaaaaaaaaa......
.......aaaaaaa}.....
.......aaaaaaaa<....
......{aaaaaaaaa....
.....>aaaaaaaaaa....
.....aaaaaaaaaaa}...
....{aaaaaaaaaaaaa<.
...>aaa.....aaaaaaa.
...aaaa.....aaaa....
............aaaa....
]])
  end

  Spawn("player", 9.5, 8)
  Spawn("key", 5.5, 2.5)

  Spawn("record", 4.1, 10.5, "sounds/voices/r7")
end

function climp(wet)
  ApplyTiles(villa, 0, 0, [[
oxX+xxooooxo|.....x|
%@#@t...tt%tt.....1|
x#@&3...1oXoo......|
X$%x.....1oo3......|
xXxo.............../
ox+x,;,:.........../
o<%&$&tttt........./
o{x+Xxo7..........,/
o{oXxXo..........t&%
o{o+x7..........;o+X
o{oxo...........xXXx
o{Xxo:,.....ooo{oxoX
t$&$%&tttt..ooo{ooox
o+X+x+oooo}oooo{ooXX
oox+XXxooo}oooo{o+xo
]])

  if wet then
    ApplyTiles(acid, 0, 0, [[
.............aaaaa..
.....aaa.....aaaaa}.
....{aaa}....aaaaaa.
....aaaaa}..{aaaaaa.
....aaaaaa79aaaaaaa.
....aaaaaa46aaaaaaa.
..........13aaaaaaa.
.......>aaaaaaaaaaa.
.......aaaaaaaaaa...
.....>aaaaaaaaaaa...
.....aaaaaaaaaaa....
.....aaaaaaa........
..........aa........

]])
  else
    ApplyTiles(acid, 0, 10, [[
..........79........
..........46........
..........13........

]])
  end

  Spawn("player", 7.4, 11)
  Spawn("crystal", 6.5, 2.5)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oooo/...........oooo
oooo............oooo
oooo............oooo
oooo............oooo
oooo............oooo
oooo............oooo
oooo............oooo
oooooo---oo...oooooo
oooooo...oo...oooooo
oooooo...oo...oooooo
oooooooooooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 7.5, 11)
  Spawn("chest", 12.5, 11.5, "ruse")
end

function ruse()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oo/.............oooo
oo..............oooo
oo....o.........oooo
oo....o.........oooo
oo....o.........oooo
oo....ooooo--ooooooo
oo...........osooooo
oo...........ooooooo
oo........o--ooosooo
oo........o..ooooooo
oo........o..oooooso
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 8.2, 12)
  Spawn("chest", 14.2, 6.5, "buoyancy")

  Spawn("record", 3.8, 12.5, "sounds/voices/r7r")
end

function buoyancy()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooo.............o
ososoo.............o
oooooo.............o
ososoo...oo---oooooo
oooooo...oo...oooooo
ososoo...oo...oosooo
oooooo...ooooooooooo
oooooo........oosooo
o/............oooooo
o.............oosooo
o....ooooooooooooooo
o....ooooooooooooooo
o....ooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 2.9, 13)
  Spawn("fan", 12.5, 10.5)
  Spawn("key", 12.5, 6.5)
  Spawn("lock", 15.5, 2.5)
  Spawn("diamond", 17.5, 2.5)
end

tiles = "tiles/villa"
pattern = "backgrounds/growth"
dark = { 0.14, 0.10, 0.12 }
light = { 0.26, 0.19, 0.23 }

