-- Acid drop loop

local villa = { o = "stone", t = "stonetop", ["8"] = "stucco",
                ["7"] = "arch_l", ["9"] = "arch_r", ["1"] = "stonebottom_l", ["3"] = "stonebottom_r",
                ["|"] = "pillar",  ["T"] = "pillartop", ["/"] = "grasspillar",
                [">"] = "shadowtop_l", ["}"] = "shadow_l", ["<"] = "shadowtop_r", ["{"] = "shadow_r",
                ["x"] = "ivy_a", ["X"] = "ivy_b", ["+"] = "ivy_c",
                ["$"] = "hang_a", ["%"] = "hang_b", ["&"] = "hang_c",
                ["#"] = "bush_a", ["@"] = "bush_a",
                [","] = "grass_a", [":"] = "grass_b", [";"] = "grass_c" }

local acid = { a = "acid", ["^"] = "acidsurface",
               ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
               ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
               ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr",
               [">"] = "acidarch_l", ["}"] = "acidstonebottom_l",
               ["<"] = "acidarch_r", ["{"] = "acidstonebottom_r" }

function start()
  ApplyTiles(villa, 0, 0, [[
+Xooo...........o+Xo
xoooo...........1oxx
oooo3............tt&
ooT..............o+X
Xo|..............oox
xo|..............1oo
Xx/................T
Xx/................|
ox/:;:,,:..........|
t%$&$&%&t..........|
oX+XxX+Xo......ttttt
Xx<t%&>xx:,:;;,ooooo
xo{o+x}o+Xx+XxXXxooo
tttoXx}oo7....9o+Xoo
o8oo8x}oo......ooxX+
]])

  Spawn("player", 17, 9)
  Spawn("chest", 6.2, 8.5, "fizzer")
  Spawn("chest", 12.5, 11.5, "droplet")
end

function fizzer()
  ApplyTiles(villa, 0, 0, [[
/..................|
|..................|
|.......:;.........|
|.......@#........./
tt......@@........./
oo......##........./
8o}o3...@#,;:;,..../
oo}o....$%%&tttt.../
8o}o...$X+XxXooo...|
xo}o..1oxooooooo...|
Xx}o...............|
&$%t...............|
xXxo............tttt
X+Xo............oooo
Xx+x}oooooooooo{oooo
]])

  ApplyTiles(acid, 0, 9, [[
....^^}.........^^^.
....aaaaaaaaaaaaaaa.
....aaaaaaaaaaaaaaa.
....aaaaaaaaaaaa....
....aaaaaaaaaaaa....
]])

  Spawn("player", 12.6, 13)
  Global("box", 12.1, 6.5)
  Global("key", 15.1, 6.5)
end

function droplet(wet)
  ApplyTiles(villa, 0, 0, [[
oo|...............:|
oo|...............@|
oo|......,:.......&/
oo|;:,:.tttt......x/
ttt&%$o{oooo......X/
ooXxXxo{oooo......x/
o+x<&%ttoo7......../
oxo{oXxooo........./
+Xo{xxxo7..........|
Xxo{Xoxo.........ttt
t%&t&t$t.........ooo
o+Xoxoxo.........ooo
ooxXXoXotttttttttt>o
ooox+Xxooo8oo8oo8o}o
oo+XoxxXoooooooooo}o
]])

  if wet then
    ApplyTiles(acid, 0, 0, [[
...aaaaaaaaaaaaaaaa.
...aaaaaaaaaaaaaaa..
...aaaaaaaaaaaaaaa..
...aaaaa....aaaaaa..
............aaaaaa..
............aaaaaa..
..........>aaaaaaaa.
..........aaaaaaaaa.
........>aaaaaaaaaa.
........aaaaaaaaa...
........aaaaaaaaa...
........aaaaaaaaa...
]])
  end

  Spawn("player", 5.5, 3)
  Spawn("chest", 10.1, 11.5, "tomb")
end

function tomb(wet)
  ApplyTiles(villa, 0, 0, [[
xo....oooxX+XxXooooo
xX....oooo+xXX+xoooo
T&.....9oooooX+xXooo
|x......1ooooox+XXxo
/X..............T.xX
/3..............|.ox
/...............|;ox
/..........tttttt&$&
/..........ooooooo+X
|..........o88ooo88x
|..........ooooooooo
|..,:;,....o88ooo88o
tttt$$@,:,;$ttt>oooo
oooXxX%#@#%xooo}o88o
oo+xX+X$&$+xXoo}oooo
]])

  if wet then
    ApplyTiles(acid, 0, 1, [[
..^^^^..............
..aaaaaa............
..aaaaaa}...........
..aaaaa7889aaaaa.a..
.{aaaaa4556aaaaa.a..
.aaaaaa4556aaaaa.a..
.aaaaaa1223.........
.aaaaaaaaaa.........
.aaaaaaaaaa.........
.aaaaaaaaaa.........
.aaaaaaaaaa.........
.......aaaa.........
]])
  else
    ApplyTiles(acid, 0, 9, [[
.......7889.........
.......4556.........
.......4556.........
.......1223.........
]])
  end

  Spawn("player", 3.8, 11)
  Spawn("lock", 12.5, 5.5)
  Spawn("crystal", 14.5, 5.5)
end

tiles = "tiles/villa"
pattern = "backgrounds/growth"
dark = { 0.14, 0.10, 0.12 }
light = { 0.26, 0.19, 0.23 }

