-- Stack 'n' wet

local villa = { o = "stone", t = "stonetop", ["8"] = "stucco",
                ["7"] = "arch_l", ["9"] = "arch_r", ["1"] = "stonebottom_l", ["3"] = "stonebottom_r",
                ["|"] = "pillar",  ["T"] = "pillartop", ["/"] = "grasspillar",
                [">"] = "shadowtop_l", ["}"] = "shadow_l", ["<"] = "shadowtop_r", ["{"] = "shadow_r",
                ["x"] = "ivy_a", ["X"] = "ivy_b", ["+"] = "ivy_c",
                ["$"] = "hang_a", ["%"] = "hang_b", ["&"] = "hang_c",
                ["#"] = "bush_a", ["@"] = "bush_a",
                [","] = "grass_a", [":"] = "grass_b", [";"] = "grass_c" }

local water = { w = "water", ["^"] = "watersurface",
                ["7"] = "buoyul", ["8"] = "buoyu", ["9"] = "buoyur",
                ["4"] = "buoyl", ["5"] = "buoyc", ["6"] = "buoyr",
                ["1"] = "buoydl", ["2"] = "buoyd", ["3"] = "buoydr",
                [">"] = "waterarch_l", ["}"] = "waterstonebottom_l",
                ["<"] = "waterarch_r", ["{"] = "waterstonebottom_r" }

function start()
  ApplyTiles(villa, 0, 0, [[
|o+Xxooo........|oxX
|+Xxooo3.......ttt$%
|xX.1o3........oo+Xx
|Xo............ooXxo
/x3............1o+XX
/................oXx
/:,..............oxo
/x+............,;+Xo
/Xx;:..........t&$%t
&$&%ttt........o+Xxo
X+XXxoooooo....X+Xoo
oX+xXoooooo.:,:xXooo
+xXxoo<tttttt&$&%t>o
+Xxooo{ooooox+XxXo}o
Xxoooo{oooo+XxXo+X}o
]])

  Spawn("chest", 5, 8.5, "ledge")
  Spawn("player", 9, 9)
  Spawn("chest", 13, 11.5, "floater")

  Spawn("record", 16.1, 7.5, "sounds/voices/r9")
end

function ledge(wet)
  ApplyTiles(villa, 0, 0, [[
oo.............ooooo
oo.............1ooo+
o3..............T.ox
T...............|.xX
|.....ttttt...;,/:xo
|.....ooooo>ooo&%%xo
|.....ooooo}ooo+xXoo
|...ttttttttt>ooxXoo
|...oooooooo3...9+xo
|................oXo
|.........:......oxX
|....,;:;,@..ttttt&t
tttttt%&#@#..oooooxo
oooooX+X$&%,:oooo+xo
oooo+xooxX+xo>oooXoo
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
..wwwwwwwwwwwww.....
..wwwwwwwwwwwww}....
.{wwwwwwwwwwwwww.w..
.wwwwwwwwwwwwwww.w..
.wwwww.....wwwww.w..
.wwwww..............
.wwwww..............
.www................
.www........{www<...
.wwwwwwwwww79wwww...
.wwwwwwwwww46wwww...
.wwwwwwwww.13.......
...........ww.......
...........ww.......
]])
  else
    ApplyTiles(water, 0, 11, [[
...........79.......
...........46.......
...........13.......
]])
  end

  Spawn("player", 10, 3)
  Spawn("chest", 7.1, 3.5, "puddle")
  Spawn("box", 13.5, 4.5)
  Global("key", 15, 10.5)
end

function floater(wet)
  ApplyTiles(villa, 0, 0, [[
|..........1&@#$xXxo
/................x+x
/,...............1o+
/X.................T
/x............@....|
/+.................|
/X.................|
/..................|
/................../
|.................;/
|..............,,:#/
tttttttttt...ttt$&&$
o8oo8oo8oo...1ooxX+X
oooooooooo...ooxX+xX
oooooooooooooooox+Xo
]])

  if wet then
      ApplyTiles(water, 0, 4, [[
.......7888889.^^^^.
.......4555556wwwww.
.......4555556wwwww.
.7888891222223wwwww.
.122223wwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwww..
..........www.......
..........www}......
..........www.......
]])
    Spawn("player", 3.8, 6)
  else
      ApplyTiles(water, 0, 7, [[
.......7888889......
.......4555556......
.7888894555556......
.1222231222223......
]])
    Spawn("player", 3.8, 8)
  end

  Spawn("crystal", 11.5, 12.5)
  Spawn("lock", 14.5, 2.5)
end

function puddle(wet)
  ApplyTiles(villa, 0, 0, [[
oooooo.........ooooo
o8oo8o.........1ooox
ooooo3...........9oX
ooxo7.............+x
+X+X...............X
XxX....;,;:,:......X
+xX....$&$&%tt.....x
#...;:;+Xx+Xxo,,...X
@...@#+Xx+X+#@#@...@
#...#@#x+#@##@.....#
@.....@@#@#@.......@
#..................@
@#@...........@#@..#
%$@#@.........@@#@#@
Xx&@@##@@#@#@@#&&$%$
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
......^^^^^^^^^}....
.....{wwwwwwwwwww<..
....>wwwwwwwwwwwww..
....wwwwwwwwwwwwwww.
...wwwwwwwwwwwwwwww.
...wwww.......wwwww.
.wwwwww.......wwwww.
.www............www.
.www..........wwwww.
.wwwww......wwwwwww.
.wwwwwwwwwwwwwwwwww.
...wwwwwwwwwww...ww.
.....wwwwwwwww......
]])
  else
    ApplyTiles(water, 0, 8, [[
.^^^............^^^.
.www..........wwwww.
.wwwww......wwwwwww.
.wwwwwwwwwwwwwwwwww.
...wwwwwwwwwww...ww.
.....wwwwwwwww......
]])
  end

  Spawn("player", 11, 5)
end

tiles = "tiles/villa"
pattern = "backgrounds/growth"
dark = { 0.16, 0.11, 0.10 }
light = { 0.34, 0.21, 0.16 }

