-- Water introduction

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start()
  ApplyTiles(sewer, 0, 0, [[
|.......|#|........|
|.......|#|........|
|.......|#|........|
|.......|#|........|
|.......|#|.....xxxo
|.......|#|.......9|
|.......|#|........|
oyyo....oxoxx......|
[]#|...............|
][]|............xxxo
[]#|...............|
][]|...............|
[]#|...............|
][]|...............|
[]#oyyyyyyyyyyyyyyyo
]])

  ApplyTiles(water, 0, 9, [[
....^^^^^^^^^^^^....
....wwwwwwwwwwwwwww.
....wwwwwwwwwwwwwww.
....wwwwwwwwwwwwwww.
....wwwwwwwwwwwwwww.
]])

  Spawn("player", 2.5, 6)
  Spawn("chest", 17.5, 3.5, "cupboard")

  Spawn("record", 1.7, 6.5, "sounds/voices/s1")
end

function cupboard(wet)
  ApplyTiles(sewer, 0, 0, [[
|..................|
|..................|
|..................|
|..................|
|............xxxxxxo
|.................9|
|..................|
|..............xx..|
|..................|
|..................|
oyyo.........xoyyyyo
][]|..........|[][][
[]#|..........|#[][]
][]oyyyyo....o|[][][
[][][][]oyyyyo|#[][]
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwww.......
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwww..ww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
....wwwwwwwww.......
....wwwwwwwwww......
....wwwwwwwwww......
.........wwww.......
]])
  else
    ApplyTiles(water, 0, 10, [[
....^^^^^^^^^.......
....wwwwwwwwww......
....wwwwwwwwww......
.........wwww.......
]])
  end

  Spawn("player", 2.5, 9)
  Spawn("crystal", 16.0, 1.5)
end

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

