-- Water differences

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start()
  ApplyTiles(sewer, 0, 0, [[
[][][][][][][][][][]
]oxxxxxo#[][][][][][
#|7...9|[][][][][][]
]|.....ooxxxxxxxxxo[
#|.....||7.......9|#
]|.....||.........|[
#|.....||.........|#
]oyyo..||.........|[
[][]|..oooo....oyyo#
][]#|..|[]|....|#[][
[][]|..oooo....|[][]
][]#|..........|#[][
[][]|..........|[][]
][]#|..........|#[][
[][]oyyyyyyyyyyo[][]
]])

  ApplyTiles(water, 0, 8, [[
.....^^....^^^^.....
.....ww....wwww.....
.....ww....wwww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
]])

  Spawn("player", 3.1, 6)
  Spawn("chest", 16, 7.5, "toggle")

  Spawn("record", 9.9, 7.5, "sounds/voices/s2")
end

function toggle(wet)
  ApplyTiles(sewer, 0, 0, [[
[][][][][][][][][][]
oxxxxxxxxxxxxxxxoxxo
|7..............x..|
|..................|
|..................|
oyyyo..............|
[][]|..............|
][]#|..............|
[][]|.....ooo......|
][]#|.....|#|......|
[][]|.....|#|......|
][]#|.....|#|......|
[][]oyyyyyo#oyyyyyyo
][][][][]#|#|[][][][
[][][][][]|#|#[][][]
]])

  if wet then
    ApplyTiles(water2, 0, 2, [[
.wwwwwwwwwwwwwww....
.wwwwwwwwwwwwwww456.
.wwwwwwwwwwwwwwwwww.
.....wwwwwwwwwwwwww.
.....wwwwwwwwwwwwww.
.....wwwwwwwwwwwwww.
.....wwwww...wwwwww.
.....wwwww...wwwwww.
.....wwwww...wwwwww.
.....wwwww...wwwwww.
]])
    Spawn("key", 18, 2.5)
  else
    ApplyTiles(water2, 0, 11, [[
................456.
]])
    Spawn("key", 18, 10.5)
  end

  Spawn("player", 7.6, 11)
  Spawn("lock", 4, 3.5)
  Spawn("crystal", 2.5, 3.5)
  Spawn("box", 13.9, 11.5)
end

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

