-- Water feedback

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start(wet)
  ApplyTiles(sewer, 0, 0, [[
[][][][]#|........|#
]oxxxxxxo|........|[
#|.....9||........|#
]|......||........|[
#|......||........|#
]|....xx||........|[
#|....oooo........|#
]|................|[
#|..............xxo#
]|...............9|[
#|''''''oyyo......|#
]|......|[]|......|[
#|......|[]|......|#
]|......|[]|......|[
#|......|[]oyyyyyyo#
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
..........^^^^^^^^..
..........wwwwwwww..
..^^^^^^..wwwwwwww..
..wwwwww..wwwwwwww..
..wwww....wwwwwwww..
..wwww....wwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwww....
..wwwwwwwwwwwwwwww..
..''''''....wwwwww..
..wwwwww....wwwwww..
..wwwwww....wwwwww..
..wwwwww....wwwwww..
..wwwwww............
]])
  else
    ApplyTiles(water, 0, 10, [[
............^^^^^^..
............wwwwww..
............wwwwww..
............wwwwww..
]])
  end

  Spawn("key", 7.3, 4.5)
  Spawn("player", 10, 9)
  Spawn("chest", 16.7, 7.5, "dam")
end

function dam(wet)
  ApplyTiles(sewer, 0, 0, [[
|.........|#[][][]#|
|.........|[][][][]|
|.........oxxxxxxxxo
|.................9|
|..................|
oyyo...............|
[]#|..........oyyyyo
][]|..........|[][]|
[]#|..........|#[]#|
][]|..........oxxxxo
[]#|...............|
][]|...............|
[]#|...............|
][]oyyyyyyyyyyyyyyyo
[][][][][][][][][][]
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
.wwwwwwwww..........
.wwwwwwwww..........
.wwwwwwwww..........
.wwwwwwwwww789wwwww.
.wwwwwwwwww456wwwww.
....wwwwwww456wwwww.
....wwwwwww123......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwwwwwwww.
....wwwwwwwwwwwwwww.
....wwwwwwwwwwwwwww.
]])
  else
    ApplyTiles(water, 0, 9, [[
...........789......
...........456......
...........456......
...........123......
]])
  end

  Spawn("box", 2.5, 4.5)
  Spawn("player", 6.5, 12)
  Spawn("lock", 15.5, 11.5)
  Spawn("crystal", 17.5, 11.5)
  Spawn("chest", 16.4, 5.5, "start")

  Spawn("record", 10.2, 12.5, "sounds/voices/s3")
end

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

