-- Water recursion

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start(wet)
  ApplyTiles(sewer, 0, 0, [[
|.............|#[]#|
|.............|[][]|
|7...........ooooooo
|............|#|...|
|............|#|...|
|............|#|...|
|wwwo........|#|...|
|www|........|#|...|
|www|x.......|#|...|
oxxxxx......xooo...|
|..................|
|.......xx.........|
|.......||.........|
oyy..yyy||yyyyyyyyyo
[]#..#[]||[][][][][]
]])

  if wet then
    ApplyTiles(water, 0, 2, [[
.^^^^^^^^^^^^.......
.wwwwwwwwwwww...www.
.wwwwwwwwwwww...www.
.wwwwwwwwwwww...www.
.www.wwwwwwww...www.
.www.wwwwwwww...www.
.www..wwwwwww...www.
......wwwwww....www.
.ww79wwwwwwwwwwwwww.
.ww46www..wwwwwwwww.
.ww46www..wwwwwwwww.
...13...............
...ww...............
]])
  else
    ApplyTiles(water, 0, 6, [[
.^^^................
.www................
.www................
....................
....................
....................
...79...............
...46...............
...46...............
]])
  end

  -- add overhang after so water surface effect is okay
  ApplyTiles(sewer, 0, 0, [[
|#[]|...............
oxxxo...............
]])

  Spawn("player", 6.5, 12)
  Spawn("key", 2, 12.5)
  Spawn("chest", 11, 12.5, "start")
  Spawn("lock", 13, 11.5)
  Spawn("lock", 15, 11.5)
  Spawn("crystal", 17.5, 4.5)
end

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

