-- Water latch

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start()
  ApplyTiles(sewer, 0, 0, [[
[]|..............|[]
]#|..............|#[
[]|..............|[]
]#|..............|#[
[]|..............|[]
]#|..............|#[
[]oyyyyyyyo......|[]
]#|[][][]#|......|#[
[]|#[][][]|......|[]
]#|[][][]#|......|#[
[]|#[][][]|......|[]
]#|[][][]#|......|#[
[]|#[][][]|......|[]
]#oooooooooyyyyyyo#[
[]|#[][][]|[][][]|[]
]])

  ApplyTiles(water, 0, 8, [[
...........^^^^^^...
...........wwwwww...
...........wwwwww...
...........wwwwww...
...........wwwwww...
]])

  Spawn("player", 4.6, 5)
  Spawn("chest", 7.5, 5.5, "latch")

  Spawn("record", 3.4, 5.5, "sounds/voices/s5")
end

function latch(wet)
  ApplyTiles(sewer, 0, 0, [[
[]#oxxxxxxxxxxxo[][]
][]|7..........|#[][
[]#|...........|[][]
][]|....oyyo...|#[][
[]#|....|[]|...|[][]
][]|....|[]|...|#[][
[]#|x...|[]|...|[][]
oooox...oxxo...ooooo
|..................|
|..................|
|.......o..o.......|
|.......|..|.......|
oyyyyyyy|..|yyyyyyyo
][][][]#|..|#[][][][
[][][][]|..|[][][][]
]])

  if wet then
    ApplyTiles(water, 0, 6, [[
.....^^^....^^^.....
.....www....www.....
.wwwwwwww79wwwwwwww.
.wwwwwwww46wwwwwwww.
.wwwwwww.13.wwwwwww.
.wwwwwww.ww.wwwwwww.
.........ww.........
.........ww.........
.........ww.........
]])
  else
    ApplyTiles(water, 0, 10, [[
.........79.........
.........46.........
.........13.........
.........ww.........
.........ww.........
]])
  end

  Spawn("player", 2.5, 11)
  Spawn("chest", 17.5, 11.5, "vault")
end

function vault(wet)
  ApplyTiles(sewer, 0, 0, [[
[][]|#[][][][]|#[][]
][]#|[][][][]#|[][][
#oxxoxxxxxxxxxoxxxxo
]|7................|
#|.................|
]|.................|
#oyyo.........oyyyyo
][]#|.........|[][][
[][]|.........|#[][]
][]#|.........|[][][
[][]|.....o...|#[][]
][]#|.....|...|[][][
[][]oyyyyy|yyyo#[][]
][][][][]#|[][][][][
[][][][][]|#[][][][]
]])


  if wet then
    ApplyTiles(water, 0, 3, [[
..wwwwwwwww789wwwww.
..wwwwwwwww456wwwww.
..wwwwwwwww456wwwww.
.....wwwwww123......
.....wwwwwwwww......
.....wwwwwwwww......
.....wwwwwwwww......
.....wwwww.www......
.....wwwww.www......
]])
  else
    ApplyTiles(water, 0, 8, [[
...........789......
...........456......
...........456......
...........123......
]])
  end

  Spawn("key", 3.1, 5.5)
  Spawn("player", 7, 11)
  Spawn("lock", 15.5, 4.5)
  Spawn("crystal", 17.5, 4.5)
end  

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

