-- Water latch

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start(wet)
  ApplyTiles(sewer, 0, 0, [[
#|.........oxxxxxxxo
]|.................|
#|.................|
]|.................|
ooxxxxxxo.....oyyyyo
|7............|[][][
|.............|#[][]
|.............|[][][
oyyo..........|#[][]
][]|..........|[][][
[]#|..........|#[][]
][]|..........|[][][
[]#oyyyyyyyyyyo#[][]
][][][][][][][][][][
[][][][][][][][][][]
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
..wwwwwwwww.........
..wwwwwwwww789wwwww.
..wwwwwwwww456wwwww.
..wwwwwwwww456wwwww.
.........ww123......
.wwwwwwwwwwwww......
.wwwwwwwwwwwww......
.wwwwwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
....wwwwwwwwww......
]])
  else
    ApplyTiles(water, 0, 8, [[
...........789......
...........456......
...........456......
...........123......
]])
  end

  Spawn("player", 4, 3)
  Spawn("box", 7.2, 3)
  Spawn("lock", 15, 2.5)
  Spawn("crystal", 17.5, 2.5)
  Spawn("chest", 2.5, 7.5, "first")
end

function first(wet)
  ApplyTiles(sewer, 0, 0, [[
#|................|#
]|................|[
#oooo..........oooo#
][]#|..........|#[][
[][]|..........|[][]
][]#|..xxxxxx..|#[][
[][]|..........|[][]
][]#|..........|#[][
#ooooxxxx..xxxxoooo#
]|7..............9|[
#|................|#
]|................|[
#oyyo..........oyyo#
][]#|''''''''''|#[][
[][]|..........|[][]
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
..^^^^^^^^^^^^^^^^..
.....wwwwwwwwww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
.....ww......ww.....
.....wwwwwwwwww.....
.....wwwwwwwwww.....
.........ww.........
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
.....wwwwwwwwww.....
.....''''''''''.....
.....wwwwwwwwww.....
]])
  end

  Spawn("player", 10, 3)
  Spawn("chest", 3.5, 11.5, "second")
  Spawn("key", 16.5, 11.5)
end

function second(wet)
  ApplyTiles(sewer, 0, 0, [[
oxxxxxxxxxoxxxxxxxxo
|7.......9|7......9|
|.........|........|
|.........|........|
|.........|........|
|...ooo...ooo...oyyo
|...|||...|||...|#[]
|...|||...ooo...|[][
oyyyooo....x....|#[]
][][]#|.........|[][
[][][]|.........|#[]
][][]#|.........|[][
[][][]|....x....|#[]
][][]#oyyyyyyyyyo[][
[][][][][][][][][][]
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.wwwwwwwww.wwwwwwww.
.wwwwwwwww.wwwwwwww.
.wwwwwwwww.wwwwwwww.
.wwwwwwwww.wwwwwwww.
.www...www...www....
.www...www...www....
.www...www...www....
.......wwww.wwww....
.......wwwwwwwww....
.......wwwwwwwww....
.......wwwwwwwww....
.......wwww.wwww....
]])
  else
    ApplyTiles(water, 0, 5, [[
.......^^^...^^^....
.......www...www....
.......www...www....
.......wwww.wwww....
.......wwwwwwwww....
.......wwwwwwwww....
.......wwwwwwwww....
.......wwww.wwww....
]])
  end

  Spawn("player", 17.5, 4)
  Spawn("lock", 11.5, 10.5)
  Spawn("chest", 2.5, 7.5, "start")
end  

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

