-- Water exchange difference

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start()
  ApplyTiles(sewer, 0, 0, [[
[][][]#|[][][][][]#|
][][][]oxxxxxxxxxxxo
[][][]#|7.........9|
][][][]|...........|
[][][]#|...........|
][][][]|...........|
[][][]#|...........|
oxxxxxxo.........ooo
|................|[]
|................|#[
|................|[]
oyyyyyyyyyyyyyyyyo#[
|#[][][][][][][]#|[]
|[][][][][][][][]|#[
|#[][][][][][][]#|[]
]])

  Spawn("crystal", 2.5, 9.5)
  Spawn("lock", 4.5, 9.5)
  Spawn("lock", 6.5, 9.5)
  Spawn("chest", 9.5, 10.5, "swapper")
  Spawn("player", 12.5, 10)
  Spawn("key", 15.5, 10.5)
  Spawn("chest", 18, 6.5, "oneway")
end

function oneway(wet)
  ApplyTiles(sewer, 0, 0, [[
#|[][][][][][][][]|#
]oxxxxxxxxxxxxxxxxo[
#|7...............|#
]|................|[
#|................|#
]|.....x..........|[
#|................|#
]|................|[
#|................|#
]oyyyyyyyyyo......|[
#|[][][][]#|......|#
]|#[][][][]|......|[
#|[][][][]#|......|#
]oooooooooooyyyyyyo[
[][][][][][][][][][]
]])
  
  if wet then
    ApplyTiles(water, 0, 2, [[
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwww.wwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
..wwwwwwwwwwwwwwww..
............wwwwww..
............wwwwww..
............wwwwww..
............wwwwww..
]])
  else
    ApplyTiles(water, 0, 9, [[
............^^^^^^..
............wwwwww..
............wwwwww..
............wwwwww..
]])
  end

  Spawn("player", 3.2, 8)
  Spawn("lock", 7.5, 7.5)
  Spawn("chest", 16, 12.5, "topshelf")
end

function topshelf(wet)
  ApplyTiles(sewer, 0, 0, [[
[][][][][][][][][][]
][]oxxxxxxxxxxxxo[][
[]#|............|#[]
][]|............|[][
[]#|............|#[]
][]|........oyyyo[][
[]#|........|ooo|#[]
][]|........oxxxo[][
[]#|...........9|#[]
][]|............|[][
[]#|............|#[]
][]oyyyyo.......|[][
[][][][]|.......|#[]
][][][]#|.......|[][
[][][][]oyyyyyyyo#[]
]])

  if wet then
    ApplyTiles(water, 0, 2, [[
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwww........
....wwwwwwww........
....wwwwwwww........
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
.........wwwwwww....
.........wwwwwww....
.........wwwwwww....
]])
  else
    ApplyTiles(water, 0, 11, [[
.........^^^^^^^....
.........wwwwwww....
.........wwwwwww....
]])
  end

  Spawn("player", 6.5, 10)
  Spawn("key", 14, 4.5)
end

function swapper(wet)
  ApplyTiles(sewer, 0, 0, [[
[][][][][][][][][][]
][][][][][][][][][][
[]#oxxxxxxxxxxxxo#[]
][]|7..........9|[][
[]#|............|#[]
][]|............|[][
[]#|............|#[]
][]|............|[][
[]#|.......x....|#[]
][]|............|[][
[]#|............|#[]
][]|............|[][
[]#oyyyyyyyyyyyyo#[]
][][][][][][][][][][
[][][][][][][][][][]
]])

  if wet then
    ApplyTiles(water, 0, 3, [[
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwww.wwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
]])
  end

  Spawn("player", 7.2, 11)
  Spawn("lock", 11.5, 10.5)
  Spawn("box", 14, 11.5)
end

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

