-- Water cycle

local sewer = { o = "panel", ["x"] = "box", ["|"] = "pillar", y = "pave",
                ["["] = "brick_l", ["]"] = "brick_r", ["#"] = "brick",
                ["7"] = "arch_l", ["9"] = "arch_r", ["'"] = "ledge" }

local water = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                ["7"] = "buoy_ul", ["8"] = "buoy_u", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["5"] = "buoy_c", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["2"] = "buoy_d", ["3"] = "buoy_dr" }

local water2 = { w = "water", ["^"] = "water_s", ["'"] = "ledge_wet",
                 ["4"] = "thinbuoy_l", ["5"] = "thinbuoy_c", ["6"] = "thinbuoy_r" }

function start(wet)
  ApplyTiles(sewer, 0, 0, [[
|...............|[]|
|...............|[]|
|...............|[]|
oyyo............oooo
[]#|............|#[]
][]|............|[][
[]#|............|#[]
][]|............|[][
[]#|............|#[]
][]|............|[][
[]#|............|#[]
][]oyyyyyyyyyyyyo[][
[][][][][][][][][][]
][][][][][][][][][][
[][][][][][][][][][]
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
.wwwwwwwwwwwwwww....
.wwwwwwwwwwwwwww....
.wwwwwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
]])
  else
    ApplyTiles(water, 0, 7, [[
....^^^^^^^^^^^^....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
....wwwwwwwwwwww....
]])
  end

  Spawn("player", 2.5, 2)
  Spawn("chest", 7.5, 10.5, "looper")
  Spawn("chest", 12.5, 10.5, "cavern")
end

function looper(wet)
  ApplyTiles(sewer, 0, 0, [[
[][][][][][][][][][]
][][][][][][]#oxxxo[
[][][][][][][]|...|#
oxxxxxxxxxxxxxo...oo
|7.................|
|..................|
|..................|
|..................|
|..................|
|..................|
oyyyyyyyyyyyyyo...oo
][][][][][][]#|...|[
[][][][][][][]ooooo#
][][][][][][][][][][
[][][][][][][][][][]
]])

  if wet then
    ApplyTiles(water2, 0, 4, [[
.wwwwwwwwwwwww45556.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
...............www..
...............www..
]])

    Spawn("chest", 16.5, 3.5, "start")
  else
    ApplyTiles(water2, 0, 9, [[
..............45556.
]])

    Spawn("chest", 16.5, 8.5, "start")
  end

  Spawn("player", 3, 9)

  Spawn("record", 16.5, 11.5, "sounds/voices/s8")
end

function cavern(wet)
  ApplyTiles(sewer, 0, 0, [[
[][][][]#|...|[][][]
oxxxxxxxxo...|#[][][
|7.......|...|[][][]
|........|...|#[][][
|........|...oxxxxxo
|........|.........|
oooxxxx..|.........|
]#|......o.........|
[]|.............oyyo
]#|.............|[][
[]|.............|#[]
]#oooooooooooo..|[][
[][][][][][]#|..|#[]
][][][][][][]oooo[][
[][][][][][]#|[]|#[]
]])

  if wet then
    ApplyTiles(water, 0, 0, [[
..........www.......
..........www.......
..........www.......
..........www.......
..........www.......
..........wwww79www.
.......^^.wwww46www.
...wwwwww.wwww46www.
...wwwwwwwwwww13....
...wwwwwwwwwwwww....
...wwwwwwwwwwwww....
..............ww....
..............ww....
]])
  else
    ApplyTiles(water, 0, 9, [[
..............79....
..............46....
..............46....
..............13....
]])
  end
  
  Spawn("player", 5, 10)
  Spawn("crystal", 17.5, 6.5)
end

tiles = "tiles/crucible"
pattern = "backgrounds/scuzz"
dark = {0.03, 0.05, 0.09}
light = {0.09, 0.13, 0.17}

