-- Fissure water level swaps

local temple = { o = "panel", ["<"] = "winglet_l", [">"] = "winglet_r",
                 ["1"] = "pillar_l", ["2"] = "pillar_c", ["3"] = "pillar_r",
                 ["i"] = "screw_u", ["j"] = "screw_d", 
                 ["["] = "brick_l", ["#"] = "brick_cr", [","] = "brick_broke" }

local water = { w = "water", ["^"] = "water_s", ["<"] = "wingwet_l", [">"] = "wingwet_r",
                ["7"] = "buoy_ul", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["3"] = "buoy_dr" }

function start()
  ApplyTiles(temple, 0, 0, [[
i2i2i22222222222222i
j.j.j..............j
i.i.i..............i
j.j.j..............j
i.i.i..............i
j.j,j..............j
i.i[i.......<ooooooi
j,j[j........122222j
i[i[i........122222i
j[j[j........122222j
i[i[i........122222i
j[j[j........122222j
i[i[i........122222i
oooooooooooooooooooo
i[##i[#############i
]])

  ApplyTiles(water, 0, 8, [[
.....^^^^^^^^.......
.....wwwwwwww.......
.....wwwwwwww.......
.....wwwwwwww.......
.....wwwwwwww.......
]])
  Spawn("player", 16.8, 5)
  Spawn("chest", 13.9, 5.5, "pasture")

  Spawn("record", 18.6, 5.5, "sounds/voices/t11")
end

function pasture(wet)
  ApplyTiles(temple, 0, 0, [[
iooooooooooooooooooi
j............1223[#j
i............1223..i
j............1223..j
i............1223..i
j............1223..j
i............1223..i
joooo>.......1223..j
i2223........oooo..i
j2223........o.....j
i2223........o.....i
j2223..............j
i2223..............i
j2223..............j
oooooooooooooooooooo
]])

  if wet then
    ApplyTiles(water, 0, 4, [[
.................79.
.^^^^^^^^^^^^....46.
.wwwwwwwwwwww....13.
.....>wwwwwww....ww.
.....wwwwwwww....ww.
.....wwwwwwww.wwwww.
.....wwwwwwww.wwwww.
.....wwwwwwwwwwwwww.
.....wwwwwwwwwwwwww.
.....wwwwwwwwwwwwww.
]])
    Spawn("box", 17.9, 3.5)
  else
    ApplyTiles(water, 0, 11, [[
.................79.
.................46.
.................13.
]])
    Spawn("box", 17.9, 10.5)
  end

  Spawn("crystal", 2.5, 2.5)
  Spawn("key", 4.2, 6.5)
  Spawn("yield", 7, 13)
  Spawn("player", 10, 13)
  Spawn("lock", 13.5, 12.5)
end

tiles = "tiles/temple"
pattern = "backgrounds/worship"
dark = {0, 0.05, 0.06}
light = {0, 0.14, 0.23}

