-- Fissure recurse water

local temple = { o = "panel", ["<"] = "winglet_l", [">"] = "winglet_r",
                 ["1"] = "pillar_l", ["2"] = "pillar_c", ["3"] = "pillar_r",
                 ["i"] = "screw_u", ["j"] = "screw_d", 
                 ["["] = "brick_l", ["#"] = "brick_cr", [","] = "brick_broke" }

local water = { w = "water", ["^"] = "water_s", ["<"] = "wingwet_l", [">"] = "wingwet_r",
                ["7"] = "buoy_ul", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["3"] = "buoy_dr" }

local glitch = { o = "glitch", [">"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start(wet)
  ApplyTiles(temple, 0, 0, [[
i222222222222222222i
j..................j
i..................i
j..................j
i...............<ooi
j................12j
i................12i
j................12j
iooo>.........oooooi
j223..........i[###j
i223..........j[###i
j223..........i[###j
i223...ooooo..j[###i
j223...o222i..i[###j
oooooooo222j..j[###i
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.wwwwwwwwwww79wwwww.
.wwwwwwwwwww46wwwww.
.wwwwwwwwwww46wwwww.
.wwwwwwwwwww46ww<...
.wwwwwwwwwww46www...
.wwwwwwwwwww46www...
.wwwwwwwwwww46www...
....>wwwwwww46......
....wwwwwwww46......
....wwwwwwww46......
....wwwwwwww46......
....www.....46......
....www.....46......
............46......
]])
  else
    ApplyTiles(water, 0, 11, [[
............79......
....^^^.....46......
....www.....46......
............46......
]])
  end

  Spawn("player", 10.5, 11)
  Spawn("yield", 3, 7)
  Global("chest", 8.4, 11.5, "start")
  Spawn("crystal", 17.5, 2.5)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
osooosoooooooooooooo
oooooooo.........>oo
oooooooo..........oo
oooooooo..........oo
osooosoo..........oo
oooooooo..........oo
oooooooo-----ooooooo
ooo..........ooooooo
ooo..........ooooooo
ooo.....oooooooooooo
ooo.....oooooooooooo
ooo.....oooooooooooo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 4.5, 12)
  Spawn("chest", 15.5, 6.5, "gauntlet")
end

function gauntlet()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
ooooooooooooooo..>oo
ooo.....>oooooo...oo
ooo......osooso...oo
ooo......oooooo...oo
ooo......osooso...oo
ooo......oooooo...oo
ooo...oooooo......oo
ooo...osooso......oo
ooo...oooooo...ooooo
ooo............ooooo
ooo............ooooo
ooo............oosoo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 8.1, 12)
  Global("fan", 4.5, 12.5)
  Spawn("diamond", 16.5, 2.5)
  Spawn("chest", 7.5, 6.5, "reject")

  Spawn("record", 10.5, 12.5, "sounds/voices/t12r")
end

tiles = "tiles/temple"
pattern = "backgrounds/worship"
dark = {0, 0.05, 0.06}
light = {0, 0.14, 0.23}

