-- Fissure water switch

local temple = { o = "panel", ["<"] = "winglet_l", [">"] = "winglet_r",
                 ["1"] = "pillar_l", ["2"] = "pillar_c", ["3"] = "pillar_r",
                 ["i"] = "screw_u", ["j"] = "screw_d", 
                 ["["] = "brick_l", ["#"] = "brick_cr", [","] = "brick_broke" }

local water = { w = "water", ["^"] = "water_s", ["<"] = "wingwet_l", [">"] = "wingwet_r",
                ["7"] = "buoy_ul", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["3"] = "buoy_dr" }

function start()
  ApplyTiles(temple, 0, 0, [[
i222222222222222222i
j..................j
i..................i
j..................j
i..................i
j..................j
i..................i
jooo>..........<oooj
i223............122i
j223............122j
i223......<ooooooo2i
j223.......12222222j
i223.......12222222i
oooooooooooooooooooo
i[#################i
]])

  Spawn("chest", 3.1, 6.5, "bath")
  Spawn("player", 7.2, 12)
  Spawn("key", 13.5, 9.5)
  Spawn("box", 17.2, 6.5)
end

function bath(wet)
  ApplyTiles(temple, 0, 0, [[
i22222222222i222222i
j...........j[#####j
i...........i[#####i
j...........j[#####j
i...........i[#####i
j...........j222222j
i...........o......i
j..................j
i..................i
j..................j
i..........<oo.....i
j...........oo.....j
i...........oo.....i
oooooooooooooo.....j
i[#################i
]])

  if wet then
    ApplyTiles(water, 0, 1, [[
.wwwwwwwwwww........
.wwwwwwwwwww........
.wwwwwwwwwww........
.wwwwwwwwwww........
.wwwwwwwwwww........
.wwwwwwwwwww.wwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwwwwwwwwwww.
.wwwwwwwwww<..wwwww.
.wwwwwwwwwww..wwwww.
.wwwwwwwwwww..wwwww.
..............wwwww.
]])
  else
    ApplyTiles(water, 0, 10, [[
..............^^^^^.
..............wwwww.
..............wwwww.
..............wwwww.
]])
  end

  Spawn("yield", 3.5, 12)
  Spawn("player", 7.5, 12)
  Global("lock", 12.5, 8.5)
  Spawn("crystal", 6, 2.5)
end

tiles = "tiles/temple"
pattern = "backgrounds/worship"
dark = {0, 0.05, 0.06}
light = {0, 0.14, 0.23}

