-- Fissure recurse global chest

local temple = { o = "panel", ["<"] = "winglet_l", [">"] = "winglet_r",
                 ["1"] = "pillar_l", ["2"] = "pillar_c", ["3"] = "pillar_r",
                 ["i"] = "screw_u", ["j"] = "screw_d", 
                 ["["] = "brick_l", ["#"] = "brick_cr", [","] = "brick_broke" }

local water = { w = "water", ["^"] = "water_s",
                ["7"] = "buoy_ul", ["9"] = "buoy_ur",
                ["4"] = "buoy_l", ["6"] = "buoy_r",
                ["1"] = "buoy_dl", ["3"] = "buoy_dr" }

local glitch = { o = "glitch", [">"] = "glitchd", s = "glitchsymbol", ["-"] = "glitchledge" }

function start()
  ApplyTiles(temple, 0, 0, [[
i222222222222222222i
j..................j
i..................i
j..................j
i..................i
j..................j
ioooooooo>.....<oooi
j22222223.......122j
i22222223.......122i
j22222223.......122j
i22222223.......122i
j22222223.......122j
i22222223.......122i
oooooooooooooooooooo
i[#################i
]])

  Spawn("key", 4, 5.5)
  Spawn("key", 7.2, 5.5)
  Spawn("player", 17, 5)
  Global("chest", 12.5, 12.5, "swamp")
end

function swamp()
  ApplyTiles(temple, 0, 0, [[
i222222222222222222i
j..................j
i..................i
j..................j
i..................i
j..................j
ioooooo>...........i
j[####o............j
ioooooo........<oooi
j...o.o.........122j
i...............122i
j.............12222j
i.............12222i
oooooooooooooooooooo
i[#################i
]])

  Spawn("box", 2.1, 12.5)
  Spawn("lock", 4.5, 11.5)
  Spawn("lock", 6.5, 11.5)
  Spawn("crystal", 6.5, 2.5)
  Spawn("player", 8.9, 12)
  Spawn("yield", 11.8, 12)
  Spawn("box", 17.5, 12.5)
end

function reject()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
oossoo...........>oo
oossoo............oo
oooooo............oo
oooooo......oo....oo
oo..........oo....oo
oo..........oo....oo
oo..........oo....oo
oo..........oooooooo
oo..........oooooooo
oo..........oooossoo
oooooooooooooooossoo
oooooooooooooooooooo
oooooooooooooooooooo
]])

  Spawn("player", 4.1, 11)
  Spawn("fan", 10.7, 11.5)
  Spawn("chest", 16, 8.5, "constructo")

  Spawn("record", 8.3, 11.5, "sounds/voices/t9r")
end

function constructo()
  ApplyTiles(glitch, 0, 0, [[
oooooooooooooooooooo
oooooooooooooooooooo
o.................>o
o..................o
o..................o
o..oooooooooo--ooooo
o....ooo....o..ooooo
o....ooo.......oosoo
ooo..ooo....o..ooooo
ooo....o....o..ooooo
ooo....o....o..oosoo
ooooo..o....o..ooooo
ooooo..........ooooo
ooooo.......ooooosoo
oooooooooooooooooooo
]])

  Spawn("player", 6.5, 4)
  Spawn("key", 9.8, 13.5)
  Spawn("box", 9.7, 4.5)
  Spawn("lock", 15.5, 3.5)
  Spawn("diamond", 17.5, 3.5)
end


tiles = "tiles/temple"
pattern = "backgrounds/worship"
dark = {0, 0.05, 0.06}
light = {0, 0.14, 0.23}

