-- Chest usage

local wood = { ["7"] = "carve_ul", ["8"] = "carve_u", ["9"] = "carve_ur",
               ["4"] = "carve_l", ["="] = "backing", ["6"] = "carve_r",
               ["^"] = "plank_top", ["|"] = "plank_v", ["v"] = "plank_bottom",
               ["<"] = "plank_left", ["-"] = "plank_h", [">"] = "plank_right",
               [";"] = "bannister_l", ["~"] = "bannister_c", [":"] = "bannister_r",
               o = "panel", ["'"] = "ledge", n = "rafter_u", u = "rafter_d" }

function start()
  ApplyTiles(wood, 0, 0, [[
==u===u===u===u===u=
----><---------><---
=^................78
=|................4=
=|................4=
=|~~:..........;~~4=
=|889..........7884=
=|==6..........4==4=
=|==6.......;~~4==4=
=|88889.....7888884=
=|====6.....4=====4=
=|====6.....4=====4=
=v====6ooooo4=====4=
=<---------------->=
=^==^=======^==^==^=
]])

  Spawn("player", 9.5, 11)
  Spawn("chest", 3.8, 5.5, "prison")
  Spawn("chest", 13.5, 8.5, "storage")
  Spawn("chest", 16.5, 5.5, "treasure")

  Spawn("record", 6, 8.5, "sounds/voices/w1")
  Spawn("bird", 13.2, 4.5, {"chest-prison", "chest-treasure"}, {"box", "chest-treasure"})
end

function prison()
  ApplyTiles(wood, 0, 0, [[
====================
------------>=======
==^.........^=======
==|.........|=n=n=n=
==|.........v=u=u=u=
==|.........<-------
==v...............78
==^...............4=
==|..;~~~~~~:.....4=
==|..<------>.....4=
==|...............4=
==|............78888
==|............4====
==voooooooooooo4====
==<----------->4====
]])

  Spawn("player", 7.1, 8)
  Spawn("lock", 12.5, 7.5)
  Spawn("box", 11.8, 12.5)
end

function treasure()
  ApplyTiles(wood, 0, 0, [[
====================
====n==n==n==n==n===
====u==u==u==u==u===
==<-------------->==
==^..............788
==|..............4==
==|.........;~~~~4==
==|.........<-------
==|.........78888888
==|.........4=======
==v.........4=======
--->oooo<----><-----
==^<------->^====^==
==|=========|====|==
==|=========|====|==
]])

  Spawn("player", 5.4, 10)
  Spawn("crystal", 15.5, 5.5)
end

function storage()
  ApplyTiles(wood, 0, 0, [[
--->v..........v<---
=^................^=
=|................|=
=|........;~:.....|=
=|........<->.....|=
=|................|=
=v~~~:...........ov=
oooooo...........788
----->...........4==
=^.............oo4==
=|.............78888
=v.......ooo...4====
8889.....789...4====
===6.....4=6ooo4====
===6<--->4=67894====
]])

  Spawn("player", 4.5, 6)
  Spawn("key", 7.5, 13.5)
end

tiles = "tiles/wood"
pattern = "backgrounds/spooty"
dark = {0.02, 0.12, 0.04}
light = {0.04, 0.22, 0.12}

