-- Feedback loop

local wood = { ["7"] = "carve_ul", ["8"] = "carve_u", ["9"] = "carve_ur",
               ["4"] = "carve_l", ["="] = "backing", ["6"] = "carve_r",
               ["^"] = "plank_top", ["|"] = "plank_v", ["v"] = "plank_bottom",
               ["<"] = "plank_left", ["-"] = "plank_h", [">"] = "plank_right",
               [";"] = "bannister_l", ["~"] = "bannister_c", [":"] = "bannister_r",
               o = "panel", ["'"] = "ledge", n = "rafter_u", u = "rafter_d" }

function recurse()
  ApplyTiles(wood, 0, 0, [[
=v==u==u==u==u===v==
---><---------><----
=^...............^==
=|...............|==
=|...............|==
=|...............|78
=|...............|4=
=voooo........ooov4=
----->........<-----
=^.......^^.......78
=|....;~~||~~:....4=
=|..78889|v78888884=
=v..4===6|^4======4=
88884===6||4======4=
====4===6v|4======4=
]])

  Spawn("player", 10, 8)
  Spawn("chest", 4.1, 6.5, "sidetown")
  Spawn("chest", 15.2, 6.5, "blocker")
  Spawn("key", 3, 12.5)
  Spawn("box", 16.8, 10.5)
end

function start()
  recurse()
  Spawn("bird", 11.9, 3.5, {"chest-sidetown"}) --bird only on true start
end

function sidetown()
  ApplyTiles(wood, 0, 0, [[
=====v<-------------
========^.........^=
n=n=n=n=|.........|=
u=u=u=u=v.........|=
-----><-------->..|=
=^................|=
=|................|=
=|........;:......v=
=|........79......78
=v........46''''''4=
89.....;~~46......4=
=6.....78889......4=
=6.....4===6......4=
=6.....4===6......4=
=6ooooo4===6......4=
]])

  Spawn("player", 11, 3)
  Spawn("chest", 3.3, 13.5, "recurse")

  Spawn("bird", 15, 11.5, {"chest-recurse"}, {"chest-sidetown"})
end

function blocker()
  ApplyTiles(wood, 0, 0, [[
=====|=======|======
=n=n=|=n=n=n=|=n=n=n
=u=u=|=u=u=u=|=u=u=u
---->v<----->v<-----
=^...............^==
=|...............|==
=|...............|==
=v~:.......oooooo|==
8889.......788888|==
===6.......4=====|==
===6.......4=====|==
===6oooooo^4=====|==
8888888889|4=====v==
=========6|<--------
=========6|=========
]])

  Spawn("player", 7, 10)
  Spawn("lock", 12.5, 5.5)
  Spawn("crystal", 15.5, 5.5)
end

tiles = "tiles/wood"
pattern = "backgrounds/spooty"
dark = {0.02, 0.12, 0.04}
light = {0.04, 0.22, 0.12}

