-- Rescursive embed

local wood = { ["7"] = "carve_ul", ["8"] = "carve_u", ["9"] = "carve_ur",
               ["4"] = "carve_l", ["="] = "backing", ["6"] = "carve_r",
               ["^"] = "plank_top", ["|"] = "plank_v", ["v"] = "plank_bottom",
               ["<"] = "plank_left", ["-"] = "plank_h", [">"] = "plank_right",
               [";"] = "bannister_l", ["~"] = "bannister_c", [":"] = "bannister_r",
               o = "panel", ["'"] = "ledge", n = "rafter_u", u = "rafter_d" }

function start()
  ApplyTiles(wood, 0, 0, [[
|.................|=
|...<>..<>........|=
|.................|=
v^................v=
=|............788888
=|~:..........4=====
=voo..........4=====
--->~:........<-----
----->^...........^=
=^...^|~:.........|=
=|...|v<->........|=
=|...v--->........|=
=|............7888|=
=|............4===|=
=|oooooooooooo4===|=
]])

  Spawn("player", 3.5, 13)
  Spawn("chest", 16, 3.5, "stairs")

  Spawn("record", 16.9, 11.5, "sounds/voices/w12")
  Spawn("bird", 10.6, 4.5, {"chest-stairs"}, {"chest-trilemma", "chest-trilemma"})
end

function stairs()
  ApplyTiles(wood, 0, 0, [[
6.................|=
6...oo..oo........|=
6.................v=
89............;~~~<-
=6............<-----
=6............^^=n=n
8889..........vv=u=u
===6..........<-----
<----->...........^=
89...oo...........|=
=6...78889........|=
=6...<--->.....;~~v=
=6............^<----
=6............v=====
<----------><-------
]])

  Spawn("player", 16, 3)
  Spawn("chest", 3.5, 13.5, "trilemma")
end

function trilemma()
  ApplyTiles(wood, 0, 0, [[
==v==u==u==u==u==v==
---><----------><---
=o................78
->................4=
89................4=
=6................4=
=6................4=
=6.........;~~~:..4=
=6........<---------
->................^=
=^................|=
=|ooooo...........|=
=|7888888888888889|=
=|4==============6|=
=|4==============6|=
]])

  Spawn("player", 4, 10)
  Spawn("key", 12.8, 7.5)
  Spawn("lock", 11.5, 10.5)
  Spawn("lock", 13, 10.5)
  Spawn("lock", 14.5, 10.5)
  Spawn("crystal", 16.5, 10.5)
end

tiles = "tiles/wood"
pattern = "backgrounds/spooty"
dark = {0.02, 0.12, 0.04}
light = {0.04, 0.22, 0.12}

