-- Ledges introduction

local wood = { ["7"] = "carve_ul", ["8"] = "carve_u", ["9"] = "carve_ur",
               ["4"] = "carve_l", ["="] = "backing", ["6"] = "carve_r",
               ["^"] = "plank_top", ["|"] = "plank_v", ["v"] = "plank_bottom",
               ["<"] = "plank_left", ["-"] = "plank_h", [">"] = "plank_right",
               [";"] = "bannister_l", ["~"] = "bannister_c", [":"] = "bannister_r",
               o = "panel", ["'"] = "ledge", n = "rafter_u", u = "rafter_d" }

function start()
  ApplyTiles(wood, 0, 0, [[
-->v............v<--
^.................^=
|.................|=
|.................|=
|........<>.......|=
|.................|=
|.................|=
|..............ooov=
|..............78888
vooooo.........4====
^888889........4====
|=====6........4====
|=====6........4====
|=====6''''''''4====
|=====6........4====
]])

  Spawn("chest", 2.5, 8.5, "cavern")
  Spawn("box", 4.5, 8.5)
  Spawn("player", 4.6, 7)
  Spawn("crystal", 16.5, 5.5)

  Spawn("record", 6.8, 9, "sounds/voices/w3")
  Spawn("bird", 4.8, 2.5, {"chest-cavern"}, {"chest-boxen"}, {"box", "box"})
end

function cavern()
  ApplyTiles(wood, 0, 0, [[
=======n==n=========
=======u^^u=========
------->||<---------
^.......||.........^
|.......||.........|
|.......||.........|
|.......vv.........|
vooo..........^^...|
^889~:......;~||~~~|
|==6oo......oovvooov
|88889......78888888
|====6......4=======
|====6''''''4=======
|====6......4=======
|====6......4=======
]])

  Spawn("player", 2.5, 6)
  Spawn("chest", 17.5, 8.5, "boxen")
end

function boxen()
  ApplyTiles(wood, 0, 0, [[
==u====u====u====u==
----><--------><----
89^..............^78
=6|..............|4=
=6|..............|4=
=6|..............|4=
=6|...;~~~~~~:...|4=
=6v...<------>...|4=
889..............v4=
==6..............788
==6''''''''''''''4==
==6..............4==
==6..............4==
==6..............4==
==6..............4==
]])

  Spawn("player", 8, 6)
  Spawn("box", 11, 6.5)
end

tiles = "tiles/wood"
pattern = "backgrounds/spooty"
dark = {0.02, 0.12, 0.04}
light = {0.04, 0.22, 0.12}

