-- Instance positioning

local wood = { ["7"] = "carve_ul", ["8"] = "carve_u", ["9"] = "carve_ur",
               ["4"] = "carve_l", ["="] = "backing", ["6"] = "carve_r",
               ["^"] = "plank_top", ["|"] = "plank_v", ["v"] = "plank_bottom",
               ["<"] = "plank_left", ["-"] = "plank_h", [">"] = "plank_right",
               [";"] = "bannister_l", ["~"] = "bannister_c", [":"] = "bannister_r",
               o = "panel", ["'"] = "ledge", n = "rafter_u", u = "rafter_d" }

function start()
  ApplyTiles(wood, 0, 0, [[
=u=u=|........|=u=u=
---->v........v<----
889..............788
==6..............4==
==6..............4==
==6..............4==
==6~~~~:.........4==
-------->........4==
88889.........;~~<--
====6.........788888
====6.........4=====
====6.........4=====
----->ooooooo<------
====^788888889^=====
====|4=======6|=====
]])

  Spawn("player", 5.2, 6)
  Spawn("chest", 15.5, 8.5, "pit")
  Spawn("chest", 6.9, 11.5, "locker")

  Spawn("bird", 14.1, 3.5, {"chest-pit", "chest-locker"})
end

function pit()
  ApplyTiles(wood, 0, 0, [[
=^<-------------->^=
=|o..............o|=
=|................|=
=|.....;~~~~:.....|=
=v:....<---->....;v=
8889............7888
===6~~:......;~~4===
==78889^....o78889==
==4===6|....o4===6==
==4===6|....o4===6==
==4===6|....<-->^^78
7888889|........||4=
4=====6|....<-->||4=
4=====6|........v|4=
<----->|<------->|<-
]])

  Spawn("player", 10, 3)
  Spawn("key", 10, 13.5)
end

function locker()
  ApplyTiles(wood, 0, 0, [[
----><--------><----
==^..............788
==|..............4==
==|..............4==
==|...789......;~4==
==|...4=6......784==
==|...4=6......4=4==
==v...4=6oooooo4=4==
-->...<------------>
==^...<------>788888
==|..........^4=====
==|..........|4=====
==v..........|4=====
------------>|4=====
==^==========|4=====
]])

  Spawn("player", 10.4, 6)
  Spawn("lock", 7.5, 11.5)
  Spawn("crystal", 11.5, 11.5)
end

tiles = "tiles/wood"
pattern = "backgrounds/spooty"
dark = {0.02, 0.12, 0.04}
light = {0.04, 0.22, 0.12}

