-- Instance move

local wood = { ["7"] = "carve_ul", ["8"] = "carve_u", ["9"] = "carve_ur",
               ["4"] = "carve_l", ["="] = "backing", ["6"] = "carve_r",
               ["^"] = "plank_top", ["|"] = "plank_v", ["v"] = "plank_bottom",
               ["<"] = "plank_left", ["-"] = "plank_h", [">"] = "plank_right",
               [";"] = "bannister_l", ["~"] = "bannister_c", [":"] = "bannister_r",
               o = "panel", ["'"] = "ledge", n = "rafter_u", u = "rafter_d" }

function start()
  ApplyTiles(wood, 0, 0, [[
===|==n==nn==n==|===
===v==u==uu==u==v===
===<------------>===
--->............<---
=^................^=
=|................|=
=|................|=
=|................|=
=|......7889......|=
=|......4==6......|=
=|....78888889....|=
=|....4======6....|=
=voooo4======6oooov=
--------><----------
=^================^=
]])

  Spawn("player", 10, 7)
  Spawn("chest", 4, 11.5, "cupboard")
  Spawn("chest", 16, 11.5, "mound")

  Spawn("bird", 10, 6.5, {"chest-cupboard", "chest-mound"})
end

function cupboard()
  ApplyTiles(wood, 0, 0, [[
===^=n==n==n==n=^|==
===|=u==u==u==u=||==
===|<---------->||==
===|............||78
-->|............||4=
889v............||4=
==6^............vv4=
==6|............7888
==6|............4===
==6|............4===
==6v............4===
------><------->4===
===^o78889^788888888
===|o4===6|4========
===|o4===6|4========
]])

  Spawn("player", 6, 10)
  -- Hey, it's programmable, so let's have some fun with it
  for n=1,4 do
    for x=1,5-n do
      Spawn("box", 7.5 + 0.8 * n + 1.5 * x, 11.5 - 1.2 * n)
    end
  end
end

function mound()
  ApplyTiles(wood, 0, 0, [[
====u======u======u=
------><-------><---
==^..............^78
==|..............|4=
==|..............|4=
==v.........;~~~~|4=
==^........oooooov4=
==|........<--------
->|...........788888
89|...........4=====
=6|...........4=====
=6vooooooooooo4=====
=6<------------><---
=6^===========^==^==
=6|===========|==|==
]])

  Spawn("player", 12.5, 10)
  Spawn("crystal", 15.5, 4.5)
end

tiles = "tiles/wood"
pattern = "backgrounds/spooty"
dark = {0.02, 0.12, 0.04}
light = {0.04, 0.22, 0.12}

