-- Campaign screen layout

function start()
  Add(4, 7.5, Peg.Level, 0, "missions/basic1", "Entryway")
  Add(8, 7.5, Peg.Level, 1, "missions/basic2", "Barrera")
  Add(12, 7.5, Peg.Level, 2, "missions/basic3", "Llave")
  Add(16, 7.5, Peg.Level, 3, "missions/basic4", "Subida")
  Add(6, 11, Peg.Level, 3, "missions/basic5", "Cofres")
  Add(10, 11, Peg.Page, 5, "wood", "Bosque")
  Add(14, 11, Peg.Level, 5, "missions/basic6", "Objetivo")

  Add(4, 4, Peg.Back)
  Add(8, 4, Peg.Book, 0, "primer", "Tutorial")
  Add(12, 4, Peg.Book, 0, "credits-small", "Créditos")
  Add(16, 4, Peg.Page, 14, "skip", "Nexo")

  return { bg = {0.1, 0.04, 0.45} }
end

function wood()
  Add(8, 3, Peg.Level, 5, "missions/wood1", "Aventura")
  Add(12, 3, Peg.Level, 6, "missions/wood2", "Reiniciar")
  Add(16, 3, Peg.Level, 7, "missions/wood3", "Saliente")
  Add(6, 6, Peg.Level, 7, "missions/wood4", "Trampa")
  Add(10, 6, Peg.Level, 8, "missions/wood5", "Seguro")
  Add(14, 6, Peg.Level, 9, "missions/wood6", "Fosas")
  Add(4, 9, Peg.Level, 10, "missions/wood7", "Incómoda")
  Add(8, 9, Peg.Level, 11, "missions/wood8", "Situación")
  Add(12, 9, Peg.Level, 12, "missions/wood9", "Bucle")
  Add(16, 9, Peg.Level, 13, "missions/wood10", "Nudo")
  Add(6, 12, Peg.Page, 14, "sewer", "Alcantarilla")
  Add(10, 12, Peg.Level, 15, "missions/wood11", "Perspectiva")
  Add(14, 12, Peg.Level, 16, "missions/wood12", "Más seguro")

  Add(4, 3, Peg.Back)

  return { bg = {0.2, 0.4, 0.2} }
end

function sewer()
  Add(8, 6, Peg.Level, 14, "missions/sewer1", "Inundar")
  Add(12, 6, Peg.Level, 15, "missions/sewer2", "Drenar")
  Add(6, 9, Peg.Level, 16, "missions/sewer3", "Río de agua")
  Add(10, 9, Peg.Level, 17, "missions/sewer4", "Repetir")
  Add(14, 9, Peg.Level, 18, "missions/sewer5", "Cerrojo")
  Add(4, 12, Peg.Level, 19, "missions/sewer6", "Vortex")
  Add(8, 12, Peg.Page, 20, "castle", "Calabozo")
  Add(12, 12, Peg.Level, 21, "missions/sewer7", "Permutar")
  Add(16, 12, Peg.Level, 22, "missions/sewer8", "Instrospectiva")

  Add(10, 3, Peg.Back)

  return { bg = {0.15, 0.35, 0.5} }
end

function castle()
  Add(6, 5.5, Peg.Level, 20, "missions/basement1", "Verde")
  Add(9, 4.5, Peg.Level, 21, "missions/basement2", "Almacenar")
  Add(12, 3.5, Peg.Level, 22, "missions/basement3", "Pila")
  Add(6, 9.5, Peg.Level, 23, "missions/basement4", "Llegar")
  Add(9, 8.5, Peg.Level, 24, "missions/basement5", "Prisión")
  Add(12, 7.5, Peg.Level, 25, "missions/basement6", "Vacío")
  Add(15, 6.5, Peg.Level, 26, "missions/basement7", "Mucho más seguro")
  Add(9, 12.5, Peg.Level, 27, "missions/basement8", "Compuerta")
  Add(12, 11.5, Peg.Page, 28, "villa", "Ruinas")
  Add(15, 10.5, Peg.Level, 29, "missions/basement9", "Ático")
  Add(18, 9.5, Peg.Level, 30, "missions/basement10", "Obstrución")

  Add(3, 6.5, Peg.Back)

  return { bg = {0.3, 0.15, 0.25} }
end

function villa()
  Add(6, 3, Peg.Level, 28, "missions/garden1", "Pozo negro")
  Add(9, 3, Peg.Level, 29, "missions/garden2", "Puente")
  Add(6, 6, Peg.Level, 30, "missions/garden3", "Ácido")
  Add(9, 6, Peg.Level, 31, "missions/garden4", "Bloqueo")
  Add(12, 6, Peg.Level, 32, "missions/garden5", "Retroceso")
  Add(9, 9, Peg.Level, 33, "missions/garden6", "Baño")
  Add(12, 9, Peg.Level, 34, "missions/garden7", "Encajar")
  Add(15, 9, Peg.Level, 35, "missions/garden8", "Pilar")
  Add(12, 12, Peg.Page, 36, "temple", "Templo")
  Add(15, 12, Peg.Level, 37, "missions/garden9", "Complicado")
  Add(18, 12, Peg.Level, 38, "missions/garden10", "Trabado")

  Add(3, 3, Peg.Back)

  return { bg = {0.7, 0.65, 0.75} }
end

function temple()
  Add(10, 3, Peg.Level, 36, "missions/temple1", "Estrellas")
  Add(14, 3, Peg.Level, 37, "missions/temple2", "Reanudar")
  Add(4, 6, Peg.Level, 38, "missions/temple3", "Permanencia")
  Add(8, 6, Peg.Level, 39, "missions/temple4", "Reestructurar")
  Add(12, 6, Peg.Level, 40, "missions/temple5", "Pote")
  Add(16, 6, Peg.Level, 41, "missions/temple6", "Construir")
  Add(6, 9, Peg.Level, 42, "missions/temple7", "Interno")
  Add(10, 9, Peg.Level, 43, "missions/temple8", "Entrelazar")
  Add(14, 9, Peg.Level, 44, "missions/temple9", "Broche")
  Add(4, 12, Peg.Level, 45, "missions/temple10", "Recorrido")
  Add(8, 12, Peg.Page, 48, "dark", "El Vacío")
  Add(12, 12, Peg.Level, 49, "missions/temple11", "Hidrofóbia")
  Add(16, 12, Peg.Level, 50, "missions/temple12", "Ampolla")

  Add(6, 3, Peg.Back)

  return { bg = {0.65, 0.45, 0.1} }
end

function dark(complete)
  local x = 0.86602540378;
  Add(10, 3.5, Peg.Level, 48, "missions/dark1", "Apretón")
  Add(10 + 4 * x, 5.5, Peg.Level, 50, "missions/dark2", "Morar")
  Add(10 + 4 * x, 9.5, Peg.Level, 52, "missions/dark3", "Pago")
  Add(10, 11.5, Peg.Level, 54, "missions/dark4", "Altar")
  Add(10 - 4 * x, 9.5, Peg.Level, 56, "missions/dark5", "Escalar")
  Add(10 - 4 * x, 5.5, Peg.Level, 58, "missions/dark6", "Tríolema")

  if complete then
    Add(17.5, 7.5, Peg.Book, 0, "credits-full", "El Fin")
  end
  Add(10, 7.5, Peg.Back)

  return { bg = {0.1, 0.0, 0.1} }
end

function skip()
  Add(10, 11, Peg.Back)
  Add(4, 10, Peg.Page, 5, "wood", "Bosque")
  Add(5, 6.5, Peg.Page, 14, "sewer", "Alcantarilla")
  Add(8, 4, Peg.Page, 20, "castle", "Calabozo")
  Add(12, 4, Peg.Page, 28, "villa", "Ruinas")
  Add(15, 6.5, Peg.Page, 36, "temple", "Templo")
  Add(16, 10, Peg.Page, 48, "dark", "El Vacío")

  Add(6, 13, Peg.Hub, 28, "dlc", "La Adivinanza Ooblocosa")

  return { bg = {0.4, 0.0, 0.0} }
end

