-- Campaign screen layout

function start()
  Add(4, 7.5, Peg.Level, 0, "missions/basic1", "Entryway")
  Add(8, 7.5, Peg.Level, 1, "missions/basic2", "Barrier")
  Add(12, 7.5, Peg.Level, 2, "missions/basic3", "Key")
  Add(16, 7.5, Peg.Level, 3, "missions/basic4", "Ascent")
  Add(6, 11, Peg.Level, 3, "missions/basic5", "Chests")
  Add(10, 11, Peg.Page, 5, "wood", "Woodland")
  Add(14, 11, Peg.Level, 5, "missions/basic6", "Target")

  Add(4, 4, Peg.Back)
  Add(8, 4, Peg.Book, 0, "primer", "Primer")
  Add(12, 4, Peg.Book, 0, "credits-small", "Credits")
  Add(16, 4, Peg.Page, 14, "skip", "Nexus")

  return { bg = {0.1, 0.04, 0.45} }
end

function wood()
  Add(8, 3, Peg.Level, 5, "missions/wood1", "Journey")
  Add(12, 3, Peg.Level, 6, "missions/wood2", "Reset")
  Add(16, 3, Peg.Level, 7, "missions/wood3", "Ledges")
  Add(6, 6, Peg.Level, 7, "missions/wood4", "Trap")
  Add(10, 6, Peg.Level, 8, "missions/wood5", "Secure")
  Add(14, 6, Peg.Level, 9, "missions/wood6", "Pits")
  Add(4, 9, Peg.Level, 10, "missions/wood7", "Awkward")
  Add(8, 9, Peg.Level, 11, "missions/wood8", "Situation")
  Add(12, 9, Peg.Level, 12, "missions/wood9", "Loop")
  Add(16, 9, Peg.Level, 13, "missions/wood10", "Knot")
  Add(6, 12, Peg.Page, 14, "sewer", "Sewer")
  Add(10, 12, Peg.Level, 15, "missions/wood11", "Perspective")
  Add(14, 12, Peg.Level, 16, "missions/wood12", "More Secure")

  Add(4, 3, Peg.Back)

  return { bg = {0.2, 0.4, 0.2} }
end

function sewer()
  Add(8, 6, Peg.Level, 14, "missions/sewer1", "Flood")
  Add(12, 6, Peg.Level, 15, "missions/sewer2", "Drain")
  Add(6, 9, Peg.Level, 16, "missions/sewer3", "Basin")
  Add(10, 9, Peg.Level, 17, "missions/sewer4", "Repeat")
  Add(14, 9, Peg.Level, 18, "missions/sewer5", "Latch")
  Add(4, 12, Peg.Level, 19, "missions/sewer6", "Gyre")
  Add(8, 12, Peg.Page, 20, "castle", "Dungeon")
  Add(12, 12, Peg.Level, 21, "missions/sewer7", "Permute")
  Add(16, 12, Peg.Level, 22, "missions/sewer8", "Introspect")

  Add(10, 3, Peg.Back)

  return { bg = {0.15, 0.35, 0.5} }
end

function castle()
  Add(6, 5.5, Peg.Level, 20, "missions/basement1", "Green")
  Add(9, 4.5, Peg.Level, 21, "missions/basement2", "Store")
  Add(12, 3.5, Peg.Level, 22, "missions/basement3", "Pile")
  Add(6, 9.5, Peg.Level, 23, "missions/basement4", "Reach")
  Add(9, 8.5, Peg.Level, 24, "missions/basement5", "Gaol")
  Add(12, 7.5, Peg.Level, 25, "missions/basement6", "Empty")
  Add(15, 6.5, Peg.Level, 26, "missions/basement7", "Most Secure")
  Add(9, 12.5, Peg.Level, 27, "missions/basement8", "Sluice")
  Add(12, 11.5, Peg.Page, 28, "villa", "Ruins")
  Add(15, 10.5, Peg.Level, 29, "missions/basement9", "Attic")
  Add(18, 9.5, Peg.Level, 30, "missions/basement10", "Obstruction")

  Add(3, 6.5, Peg.Back)

  return { bg = {0.3, 0.15, 0.25} }
end

function villa()
  Add(6, 3, Peg.Level, 28, "missions/garden1", "Sinkhole")
  Add(9, 3, Peg.Level, 29, "missions/garden2", "Bridge")
  Add(6, 6, Peg.Level, 30, "missions/garden3", "Acid")
  Add(9, 6, Peg.Level, 31, "missions/garden4", "Block")
  Add(12, 6, Peg.Level, 32, "missions/garden5", "Feedback")
  Add(9, 9, Peg.Level, 33, "missions/garden6", "Bath")
  Add(12, 9, Peg.Level, 34, "missions/garden7", "Embed")
  Add(15, 9, Peg.Level, 35, "missions/garden8", "Pillar")
  Add(12, 12, Peg.Page, 36, "temple", "Temple")
  Add(15, 12, Peg.Level, 37, "missions/garden9", "Mire")
  Add(18, 12, Peg.Level, 38, "missions/garden10", "Interlock")

  Add(3, 3, Peg.Back)

  return { bg = {0.7, 0.65, 0.75} }
end

function temple()
  Add(10, 3, Peg.Level, 36, "missions/temple1", "Fissure")
  Add(14, 3, Peg.Level, 37, "missions/temple2", "Resume")
  Add(4, 6, Peg.Level, 38, "missions/temple3", "Permanence")
  Add(8, 6, Peg.Level, 39, "missions/temple4", "Restructure")
  Add(12, 6, Peg.Level, 40, "missions/temple5", "Jar")
  Add(16, 6, Peg.Level, 41, "missions/temple6", "Build")
  Add(6, 9, Peg.Level, 42, "missions/temple7", "Internal")
  Add(10, 9, Peg.Level, 43, "missions/temple8", "Entwine")
  Add(14, 9, Peg.Level, 44, "missions/temple9", "Clasp")
  Add(4, 12, Peg.Level, 45, "missions/temple10", "Traversal")
  Add(8, 12, Peg.Page, 48, "dark", "The Void")
  Add(12, 12, Peg.Level, 49, "missions/temple11", "Hydrophobic")
  Add(16, 12, Peg.Level, 50, "missions/temple12", "Blister")

  Add(6, 3, Peg.Back)

  return { bg = {0.65, 0.45, 0.1} }
end

function dark(complete)
  local x = 0.86602540378;
  Add(10, 3.5, Peg.Level, 48, "missions/dark1", "Clutch")
  Add(10 + 4 * x, 5.5, Peg.Level, 50, "missions/dark2", "Sojourn")
  Add(10 + 4 * x, 9.5, Peg.Level, 52, "missions/dark3", "Payload")
  Add(10, 11.5, Peg.Level, 54, "missions/dark4", "Altar")
  Add(10 - 4 * x, 9.5, Peg.Level, 56, "missions/dark5", "Escalate")
  Add(10 - 4 * x, 5.5, Peg.Level, 58, "missions/dark6", "Trilemma")

  if complete then
    Add(17.5, 7.5, Peg.Book, 0, "credits-full", "The End")
  end
  Add(10, 7.5, Peg.Back)

  return { bg = {0.1, 0.0, 0.1} }
end

function skip()
  Add(10, 11, Peg.Back)
  Add(4, 10, Peg.Page, 5, "wood", "Woodland")
  Add(5, 6.5, Peg.Page, 14, "sewer", "Sewer")
  Add(8, 4, Peg.Page, 20, "castle", "Dungeon")
  Add(12, 4, Peg.Page, 28, "villa", "Ruins")
  Add(15, 6.5, Peg.Page, 36, "temple", "Temple")
  Add(16, 10, Peg.Page, 48, "dark", "The Void")

  Add(6, 13, Peg.Hub, 28, "dlc", "The Oobleck Conundrum")

  return { bg = {0.4, 0.0, 0.0} }
end

