#version 330

smooth in vec2 v_uv;

out vec4 result;

uniform sampler2DArray pattern;
uniform sampler2D light;

uniform vec2 scale;
uniform float layer;

uniform vec3 darkColor;
uniform vec3 lightColor;

void main()
{
  float regular = texture(pattern, vec3(scale * v_uv, layer)).r;
  float fade = texture(light, v_uv).r;

  result.rgb = fade * mix(darkColor, lightColor, regular);
  result.a = 1.0;
}
