#version 330

smooth in vec2 v_uv;

out vec4 result;

uniform sampler2D previous;
uniform sampler2D mask;
uniform sampler2D noise;

uniform float time;

float flow(float vortexScale, vec2 offset)
{
 // noise is squished due to screen resolution, but who cares...
 vec2 shift = vortexScale * vec2(0.0, time);
 vec2 move = 2.0 * texture(noise, v_uv + offset - shift).rg - vec2(1.0);
 move.y += 0.25;

 vec2 real_uv = v_uv - 0.01 * move;

 return texture(previous, real_uv).r;
}

void main()
{
  float old1 = flow(0.18, vec2(0.0, 0.0));
  float old2 = flow(0.23, vec2(0.4, 0.6));
  float new = texture(mask, v_uv).r;

  result.r = clamp(0.5 * old1 + 0.5 * old2 - 0.04 + new, 0.0, 1.0);
  result.gb = result.rr;
  result.a = 1.0;
}
