#version 330

layout(location = 0) in vec4 position;
layout(location = 1) in vec2 textureCoord;

smooth out vec2 smoothTextureCoord;

uniform mat4 camera;

void main()
{
  vec4 correctedPosition = position;
  correctedPosition.xy += textureCoord;
  gl_Position = camera * correctedPosition;
  smoothTextureCoord = textureCoord;
}
