#version 330

layout(location = 0) in vec3 i_pos;
layout(location = 1) in int i_tile;
layout(location = 2) in vec2 i_uv;

uniform mat4 camera;
uniform sampler1D indexTexture;

smooth out vec2 v_uv;
flat out float v_tile;

void main()
{
  gl_Position = camera * vec4(i_pos.xy + i_uv, i_pos.z, 1.0);
  v_uv = i_uv;
  v_tile = texelFetch(indexTexture, i_tile, 0).r;
}
