#version 330

layout(location = 0) in vec3 i_pos;
layout(location = 1) in vec3 i_norm;
layout(location = 2) in vec3 i_col;

uniform mat4 camera;
uniform mat4 normcamera;
uniform vec3 light;

flat out vec3 v_col;

void main()
{
  gl_Position = camera * vec4(i_pos, 1.0);

  vec4 fnorm4 = normcamera * vec4(i_norm, 1.0);
  vec3 fnorm = normalize(fnorm4.xyz);

  float p = 0.5 + 0.5 * dot(light, fnorm.xyz);
  v_col = mix(i_col, vec3(0.1, 0.0, 0.1), p);
}
