#version 330

smooth in vec2 v_pos;

out vec4 result;

uniform float time;
uniform vec3 color;

void main()
{
  vec2 aspect = vec2(4 * v_pos.x, 3 * v_pos.y);
  aspect += sin(aspect.x * 2.3 + aspect.y * 1.11 - aspect.xy * 1.7 + time) * 0.3;

  float l = length(aspect);
  //float o = atan(aspect.y, aspect.x);

  float f = clamp(0.7 * (4.0 - l), 0.25, 1);
  f *= 0.9 - sin( l * l * 1.5 ) * .25 / (l * l);

  result.rgb = color;
  result.a = f;
}
