#version 330

layout(location = 0) in vec3 i_pos;
layout(location = 1) in vec4 i_col;
layout(location = 2) in vec2 i_uv;
layout(location = 3) in float i_roll;
layout(location = 4) in float i_size;

uniform mat4 camera;
uniform float scale;

flat out vec4 v_col;
smooth out vec2 v_uv;

void main()
{
  vec4 pos = vec4(i_pos, 1.0);

  vec2 off = i_size * (i_uv - 0.5);
  pos.x += off.x * cos(i_roll) +  off.y * sin(i_roll);
  pos.y += off.x * -sin(i_roll) + off.y * cos(i_roll);

  gl_Position = camera * pos;
  v_col = i_col;
  v_uv = i_uv;
}
