#version 330

smooth in vec2 v_uv;

out vec4 result;

uniform sampler2D source;
uniform sampler2D noise;

uniform float time;
uniform float param;

uniform vec4 bounds;
uniform vec2 focus;

void main()
{
  result = texture(source, v_uv);

  vec2 levelpos = bounds.xy + v_uv * bounds.zw;
  float dist = length(levelpos - focus);

  const float penumbra = 2.5;
  float circle = 27.5 - 30.0 * param;
  float shade = smoothstep(circle - penumbra, circle + penumbra, dist);
  result.rgb = mix(result.rgb, vec3(0.0), shade);
}
