#version 330

smooth in vec2 v_uv;

out vec4 result;

uniform sampler2D source;
uniform sampler2D noise;

uniform float time;
uniform float param;

uniform vec4 bounds;
uniform vec2 focus;

void main()
{
  // basic stats
  vec2 levelpos = bounds.xy + v_uv * bounds.zw;
  vec2 offset = levelpos - focus;
  float dist = length(offset);
  float theta = atan(offset.y, offset.x);

  // Circle fade
  // how much colour is going on here
  float pushdist = param * 300 - dist;

  // add chunks to it
  float skewdist = pushdist + step(0.5, 0.5 + 0.5 * sin(7.0 * theta + floor(pushdist)));

  vec3 col = normalize(vec3(abs(sin(0.1 * skewdist)),
                            abs(sin(0.12 * skewdist)),
                            abs(sin(0.13 * skewdist))));

  // alpha
  float a = 1.0 - (1.0 - param) * (0.5 + 0.5 * cos(skewdist));
  a *= step(0.0, pushdist);

  // blackout
  float b = smoothstep(270, 275, pushdist);
  vec3 bg = mix(texture(source, v_uv).rgb, vec3(0), b);

  result.rgb = mix(bg, col, a * (1.0 - b));
  result.a = 1.0;
}
