#version 330

smooth in vec2 v_uv;

out vec4 result;

uniform sampler2D source;
uniform sampler2D noise;

uniform float time;
uniform float param;

uniform vec4 bounds;
uniform vec2 focus;

void main()
{
  vec2 levelpos = bounds.xy + v_uv * bounds.zw;
  vec2 offset = levelpos - focus;
  float dist = length(offset);
  float theta = atan(offset.y, offset.x);

  float suckDist = dist + param * 15.0;
  vec2 suckPos = focus + offset * (suckDist / dist);
  vec2 suck_uv = suckPos / bounds.zw - bounds.xy;
  vec4 suckPix = texture(source, suck_uv);

  const float penumbra = 2.5;
  float circle = 27.5 - 30.0 * param;
  float shade = smoothstep(circle - penumbra, circle + penumbra, dist);
  result.rgb = mix(suckPix.rgb, vec3(0.0), shade);
  result.a = 1.0;
}
