#version 330

smooth in vec2 v_uv;

out vec4 result;

uniform sampler2D source;
uniform sampler2D noise;

uniform float time;
uniform float param;

uniform vec4 bounds;
uniform vec2 focus;

vec4 burnt(vec4 p)
{
  float brightness = dot(p.rgb, vec3(0.299, 0.587, 0.114));
  return vec4(vec3(0.2, 0.2, 0.15) * (1.0 - brightness), 1.0);
}

vec4 perturbed(float factor)
{
  vec2 offset = 2.0 * texture(noise, v_uv * 0.6).rg - 1.0;
  return texture(source, v_uv + 0.15 * factor * offset);
}

void main()
{
 float skew = texture(noise, v_uv * 0.25).r + 1.0 - 2.0 * param;
 float cskew = clamp(skew, 0.0, 1.0);

 vec4 originalPix = perturbed(max(0.0, 1.0 - skew));
 vec4 burntPix = burnt(originalPix);

 vec4 splitPix = mix(burntPix, originalPix, cskew);
 vec4 fadePix = mix(splitPix, vec4(0), clamp(param * 2.0 - 1.0, 0.0, 1.0));

 result.rgb = fadePix.rgb;
 result.a = 1.0;
}
