﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using Verse;


namespace RimWorld{
public class IncidentWorker_CropBlight : IncidentWorker
{
	const float MaxDaysToGrown = 16;


	public override bool TryExecute( IncidentParms parms )
	{
        List<Thing> plants = Find.Map.listerThings.ThingsInGroup( ThingRequestGroup.CultivatedPlant );

		bool cropFound = false;
		for( int i=plants.Count-1; i>=0; i-- )
		{
			Plant plant = (Plant)plants[i];

			if( plant.def.plant.growDays > MaxDaysToGrown )
				continue;

            if (plant.LifeStage == PlantLifeStage.Growing || plant.LifeStage == PlantLifeStage.Mature)
            {
				plant.CropBlighted();

                cropFound = true;
            }
		}

        if ( !cropFound )
            return false;
		else
		{
			Find.LetterStack.ReceiveLetter("LetterLabelCropBlight".Translate(), "CropBlight".Translate(), LetterType.BadNonUrgent);
			return true;
		}
	}
}

}