﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Verse;


namespace RimWorld{

public class IncidentWorker_RefugeePodCrash : IncidentWorker
{
	private const float FogClearRadius = 4.5f;
	private const float RelationWithColonistWeight = 20f;


	public override bool TryExecute( IncidentParms parms )
	{
		IntVec3 dropSpot = DropCellFinder.RandomDropSpot();

		Faction fac = Find.FactionManager.FirstFactionOfDef( FactionDefOf.Spacer );

		var request = new PawnGenerationRequest(PawnKindDefOf.SpaceRefugee,
			faction: fac,
			colonistRelationChanceFactor: RelationWithColonistWeight);

		Pawn refugee = PawnGenerator.GeneratePawn( request );
		HealthUtility.GiveInjuriesToForceDowned(refugee);

		string letterTitle = "LetterLabelRefugeePodCrash".Translate();
		string letterText = "RefugeePodCrash".Translate();
		PawnRelationUtility.TryAppendRelationsWithColonistsInfo(ref letterText, ref letterTitle, refugee);
		Find.LetterStack.ReceiveLetter(letterTitle, letterText, LetterType.BadNonUrgent, dropSpot);

		DropPodInfo podInfo = new DropPodInfo();
		podInfo.SingleContainedThing = refugee;
		podInfo.openDelay = 180;
		podInfo.leaveSlag = true;
		DropPodUtility.MakeDropPodAt( dropSpot, podInfo );	

		return true;
	}
}}
