﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;



namespace RimWorld{
public class CompGatherSpot : ThingComp
{
	//Working vars
	private bool active = true;
	
	public bool Active
	{
		get
		{
			return active;
		}
		set
		{
			if( value == active )
				return;

			active = value;

			if( parent.Spawned )
			{
				if( active )
					GatherSpotLister.RegisterActivated(this);
				else
					GatherSpotLister.RegisterDeactivated(this);
			}
		}
	}


	public override void PostExposeData()
	{
		Scribe_Values.LookValue(ref active, "active", false);	
	}

	public override void PostSpawnSetup()
	{
		base.PostSpawnSetup();

		if( Active )
			GatherSpotLister.RegisterActivated(this);
	}

	public override void PostDeSpawn()
	{
		base.PostDeSpawn();

		if( Active )
			GatherSpotLister.RegisterDeactivated(this);
	}

	public override IEnumerable<Command> CompGetGizmosExtra()
	{
		Command_Toggle com = new Command_Toggle();
		com.hotKey = KeyBindingDefOf.CommandTogglePower;
		com.defaultLabel = "CommandGatherSpotToggleLabel".Translate();
		com.icon = TexCommand.GatherSpotActive;
		com.isActive = ()=>Active;
		com.toggleAction = ()=>Active = !Active;

		if( Active )
			com.defaultDesc = "CommandGatherSpotToggleDescActive".Translate();
		else
			com.defaultDesc = "CommandGatherSpotToggleDescInactive".Translate();
		
		yield return com;
	}
}



public static class GatherSpotLister
{
	public static List<CompGatherSpot> activeSpots = new List<CompGatherSpot>();

	public static void Reinit()
	{
		activeSpots.Clear();
	}

	public static void RegisterActivated( CompGatherSpot spot )
	{
		if( !activeSpots.Contains(spot) )
			activeSpots.Add(spot);
	}

	public static void RegisterDeactivated( CompGatherSpot spot )
	{
		if( activeSpots.Contains(spot) )
			activeSpots.Remove(spot);
	}
}}