using UnityEngine;
using System.Collections.Generic;
using Verse;


namespace Verse.AI{
public class JobDriver_Goto : JobDriver
{
	protected override IEnumerable<Toil> MakeNewToils()
	{
		yield return Toils_Goto.GotoCell( TargetIndex.A, PathEndMode.OnCell );


		Toil arrive = new Toil();
		arrive.initAction = ()=>
		{
			// check if we arrived to our forced goto position
			if( pawn.mindState != null && pawn.mindState.forcedGotoPosition == TargetA.Cell )
				pawn.mindState.forcedGotoPosition = IntVec3.Invalid;

			if( CurJob.exitMapOnArrival && pawn.Position.OnEdge() )
				pawn.ExitMap();
		};
		arrive.defaultCompleteMode = ToilCompleteMode.Instant;
		yield return arrive;
		
	}
}}

