﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;
using RimWorld;


namespace Verse.AI{
public class JobDriver_HaulToContainer : JobDriver
{
	//Constants
	private const TargetIndex CarryThingIndex = TargetIndex.A;
	private const TargetIndex DestIndex = TargetIndex.B;

    public override string GetReport()
	{
		Thing hauledThing = null;
		if( pawn.carrier.CarriedThing != null )
			hauledThing = pawn.carrier.CarriedThing;
		else
			hauledThing = TargetThingA;

		return "ReportHaulingTo".Translate( hauledThing.LabelCap, CurJob.targetB.Thing.LabelShort );
	}

	protected override IEnumerable<Toil> MakeNewToils()
	{
		this.FailOnDestroyedNullOrForbidden( CarryThingIndex );
		this.FailOnDestroyedNullOrForbidden( DestIndex );

		//Reserve resources
		yield return Toils_Reserve.Reserve( CarryThingIndex);
		yield return Toils_Reserve.ReserveQueue( CarryThingIndex );

		//Reserve construct targets
		yield return Toils_Reserve.Reserve( DestIndex );
		yield return Toils_Reserve.ReserveQueue( DestIndex );

		Toil getToHaulTarget = Toils_Goto.GotoThing( CarryThingIndex, PathEndMode.ClosestTouch )
			.FailOnSomeonePhysicallyInteracting(CarryThingIndex);
		yield return getToHaulTarget;

		yield return Toils_Construct.UninstallIfMinifiable(CarryThingIndex)
			.FailOnSomeonePhysicallyInteracting(CarryThingIndex);

		yield return Toils_Haul.StartCarryThing(CarryThingIndex);

		yield return Toils_Haul.JumpIfAlsoCollectingNextTargetInQueue( getToHaulTarget, CarryThingIndex );

		Toil carryToContainer = Toils_Haul.CarryHauledThingToContainer();
		yield return carryToContainer;

		yield return Toils_Goto.MoveOffTargetBlueprint(DestIndex);

		yield return Toils_Construct.MakeSolidThingFromBlueprintIfNecessary(DestIndex);

		yield return Toils_Haul.DepositHauledThingInContainer(DestIndex);

		yield return Toils_Haul.JumpToCarryToNextContainerIfPossible( carryToContainer );
	}
}}

