﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;
using RimWorld;



namespace Verse.AI{
public static class Toils_Goto
{
	public static Toil Goto(TargetIndex ind, PathEndMode peMode)
	{
		return GotoThing(ind, peMode);
	}

	public static Toil GotoThing( TargetIndex ind, PathEndMode peMode)
	{
		Toil toil = new Toil();
		toil.initAction = ()=>
		{
			Pawn actor = toil.actor;
			actor.pather.StartPath( actor.jobs.curJob.GetTarget(ind), peMode );		
		};
		toil.defaultCompleteMode = ToilCompleteMode.PatherArrival;
		toil.FailOnDespawnedOrNull(ind);
		return toil;
	}
    
    public static Toil GotoThing( TargetIndex ind, IntVec3 exactCell )
    {
        Toil toil = new Toil();
        toil.initAction = ()=>
        {
            Pawn actor = toil.actor;
            actor.pather.StartPath( exactCell, PathEndMode.OnCell );       
        };
        toil.defaultCompleteMode = ToilCompleteMode.PatherArrival;
        toil.FailOnDespawnedOrNull(ind);
        return toil;
    }

	//GotoLoc does not have fail conditions
	public static Toil GotoCell( TargetIndex ind, PathEndMode peMode)
	{
		Toil toil = new Toil();
		toil.initAction = ()=>
		{
			Pawn actor = toil.actor;
			actor.pather.StartPath( actor.jobs.curJob.GetTarget(ind), peMode );		
		};
		toil.defaultCompleteMode = ToilCompleteMode.PatherArrival;
		return toil;
	}
	public static Toil GotoCell(IntVec3 cell, PathEndMode peMode)
	{
		Toil toil = new Toil();
		toil.initAction = () =>
		{
			Pawn actor = toil.actor;
			actor.pather.StartPath(cell, peMode);
		};
		toil.defaultCompleteMode = ToilCompleteMode.PatherArrival;
		return toil;
	}

	public static Toil MoveOffTargetBlueprint(TargetIndex targetInd)
	{
		Toil toil = new Toil();
		toil.initAction = () =>
		{
			Pawn actor = toil.actor;
			Thing targetBlue = actor.jobs.curJob.GetTarget(targetInd).Thing as Blueprint;

			//If already not on target blueprint, just skip this toil
			if( targetBlue == null || !GenAdj.IsInside(actor.Position, targetBlue) )
			{
				actor.jobs.curDriver.ReadyForNextToil();
				return;
			}

			//Move to a spot adjacent to the target blueprint
			IntVec3 dest;
			if( RCellFinder.TryFindGoodAdjacentSpotToTouch(actor, targetBlue, out dest) )
			{
				actor.pather.StartPath( dest, PathEndMode.OnCell );
				return;
			}

			//Could not escape blueprint
			actor.jobs.EndCurrentJob(JobCondition.Incompletable);
		};
		toil.defaultCompleteMode = ToilCompleteMode.PatherArrival;
		return toil;
	}
}}

