﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using UnityEngine;
using Verse;



namespace Verse.AI{
public static class Toils_Reserve
{
	public static Toil Reserve( TargetIndex ind, int maxPawns = 1 )
	{
		Toil toil = new Toil();
		toil.initAction = ()=>
		{
			if( !Find.Reservations.Reserve( toil.actor, toil.actor.jobs.curJob.GetTarget(ind), maxPawns ) )
				toil.actor.jobs.EndCurrentJob(JobCondition.Incompletable);
		};
		toil.defaultCompleteMode = ToilCompleteMode.Instant;
		toil.atomicWithPrevious = true;
		return toil;
	}

	public static Toil ReserveQueue( TargetIndex ind, int maxPawns = 1 )
	{
		Toil toil = new Toil();
		toil.initAction = ()=>
		{
			var queue = toil.actor.jobs.curJob.GetTargetQueue(ind);
			if( queue != null )
			{
				for( int i=0; i<queue.Count; i++ )
				{
					if( !Find.Reservations.Reserve( toil.actor, queue[i], maxPawns ) )
						toil.actor.jobs.EndCurrentJob(JobCondition.Incompletable);
				}
			}
		};
		toil.defaultCompleteMode = ToilCompleteMode.Instant;
		toil.atomicWithPrevious = true;
		return toil;
	}
	
	public static Toil Release( TargetIndex ind )
	{
		Toil toil = new Toil();
		toil.initAction = ()=>
		{
			Find.Reservations.Release( toil.actor.jobs.curJob.GetTarget(ind), toil.actor );
		};
		toil.defaultCompleteMode = ToilCompleteMode.Instant;
		toil.atomicWithPrevious = true;
		return toil;
	}


}}

